"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTabbedContent = exports.AUTOFOCUS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _tabs = require("../tabs");
var _tab = require("../tab");
var _react2 = require("@emotion/react");
var _excluded = ["className", "expand", "initialSelectedTab", "onTabClick", "selectedTab", "size", "tabs", "autoFocus"],
  _excluded2 = ["id", "name", "content"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Marked as const so type is `['initial', 'selected']` instead of `string[]`
 */
var AUTOFOCUS = exports.AUTOFOCUS = ['initial', 'selected'];
var EuiTabbedContent = exports.EuiTabbedContent = /*#__PURE__*/function (_Component) {
  function EuiTabbedContent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EuiTabbedContent);
    _this = _callSuper(this, EuiTabbedContent, [props]);
    (0, _defineProperty2.default)(_this, "rootId", (0, _services.htmlIdGenerator)()());
    (0, _defineProperty2.default)(_this, "tabsRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)(_this, "focusTab", function () {
      var targetTab = _this.tabsRef.current.querySelector("#".concat(_this.state.selectedTabId));
      targetTab.focus();
    });
    (0, _defineProperty2.default)(_this, "initializeFocus", function () {
      if (!_this.state.inFocus && _this.props.autoFocus === 'selected') {
        // Must wait for setState to finish before calling `.focus()`
        // as the focus call triggers a blur on the first tab
        _this.setState({
          inFocus: true
        }, function () {
          _this.focusTab();
        });
      }
    });
    (0, _defineProperty2.default)(_this, "removeFocus", function (blurEvent) {
      // only set inFocus to false if the wrapping div doesn't contain the now-focusing element
      var currentTarget = blurEvent.currentTarget;
      var relatedTarget = blurEvent.relatedTarget;
      if (currentTarget.contains(relatedTarget) === false) {
        _this.setState({
          inFocus: false
        });
      }
    });
    (0, _defineProperty2.default)(_this, "onTabClick", function (selectedTab) {
      var _this$props = _this.props,
        onTabClick = _this$props.onTabClick,
        externalSelectedTab = _this$props.selectedTab;
      if (onTabClick) {
        onTabClick(selectedTab);
      }

      // Only track selection state if it's not controlled externally.
      if (!externalSelectedTab) {
        _this.setState({
          selectedTabId: selectedTab.id
        }, function () {
          _this.focusTab();
        });
      }
    });
    var initialSelectedTab = props.initialSelectedTab,
      _selectedTab = props.selectedTab,
      tabs = props.tabs;

    // Only track selection state if it's not controlled externally.
    var selectedTabId;
    if (!_selectedTab) {
      selectedTabId = (initialSelectedTab === null || initialSelectedTab === void 0 ? void 0 : initialSelectedTab.id) || tabs[0].id;
    }
    _this.state = {
      selectedTabId: selectedTabId,
      inFocus: false
    };
    return _this;
  }
  (0, _inherits2.default)(EuiTabbedContent, _Component);
  return (0, _createClass2.default)(EuiTabbedContent, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        className = _this$props2.className,
        expand = _this$props2.expand,
        initialSelectedTab = _this$props2.initialSelectedTab,
        onTabClick = _this$props2.onTabClick,
        externalSelectedTab = _this$props2.selectedTab,
        size = _this$props2.size,
        tabs = _this$props2.tabs,
        autoFocus = _this$props2.autoFocus,
        rest = (0, _objectWithoutProperties2.default)(_this$props2, _excluded);

      // Allow the consumer to control tab selection.
      var selectedTab = externalSelectedTab || tabs.find(function (tab) {
        return tab.id === _this2.state.selectedTabId;
      }) || tabs[0]; // Fall back to the first tab if a selected tab can't be found

      var selectedTabContent = selectedTab.content,
        selectedTabId = selectedTab.id;
      return (0, _react2.jsx)("div", (0, _extends2.default)({
        className: className
      }, rest), (0, _react2.jsx)(_tabs.EuiTabs, {
        ref: this.tabsRef,
        expand: expand,
        size: size,
        onFocus: this.initializeFocus,
        onBlur: this.removeFocus
      }, tabs.map(function (tab) {
        var id = tab.id,
          name = tab.name,
          content = tab.content,
          tabProps = (0, _objectWithoutProperties2.default)(tab, _excluded2);
        var props = _objectSpread(_objectSpread({
          key: id,
          id: id
        }, tabProps), {}, {
          onClick: function onClick() {
            return _this2.onTabClick(tab);
          },
          isSelected: tab === selectedTab,
          'aria-controls': "".concat(_this2.rootId)
        });
        return (0, _react2.jsx)(_tab.EuiTab, props, name);
      })), (0, _react2.jsx)("div", {
        role: "tabpanel",
        id: "".concat(this.rootId),
        "aria-labelledby": selectedTabId
      }, selectedTabContent));
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiTabbedContent, "defaultProps", {
  autoFocus: 'initial'
});