"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _tabs = require("./tabs.styles");
var _tabs_context = require("./tabs_context");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "bottomBorder", "expand", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var SIZES = exports.SIZES = ['s', 'm', 'l', 'xl'];
var EuiTabs = exports.EuiTabs = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$bottomBorder = _ref.bottomBorder,
    bottomBorder = _ref$bottomBorder === void 0 ? true : _ref$bottomBorder,
    _ref$expand = _ref.expand,
    expand = _ref$expand === void 0 ? false : _ref$expand,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiTabs', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_tabs.euiTabsStyles);
  var cssStyles = [styles.euiTabs, styles[size], bottomBorder && styles.bottomBorder];
  var handleKeyDown = function handleKeyDown(event) {
    var tablist = event.currentTarget;
    var tabs = tablist === null || tablist === void 0 ? void 0 : tablist.querySelectorAll('[role="tab"]:not(:disabled, [inert])');
    if (!(tabs !== null && tabs !== void 0 && tabs.length)) return;
    var currentIndex = Array.from(tabs).findIndex(function (tab) {
      return tab.matches(':focus');
    });
    if (event.key === _services.keys.ARROW_LEFT) {
      var previousIndex = (currentIndex === 0 ? tabs.length : currentIndex) - 1;
      tabs[previousIndex].focus();
    } else if (event.key === _services.keys.ARROW_RIGHT) {
      var nextIndex = currentIndex === tabs.length - 1 ? 0 : currentIndex + 1;
      tabs[nextIndex].focus();
    }
  };
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    ref: ref,
    className: classes,
    css: cssStyles,
    onKeyDown: handleKeyDown
  }, children && {
    role: 'tablist'
  }, rest), (0, _react2.jsx)(_tabs_context.EuiTabsContext.Provider, {
    value: {
      expand: expand,
      size: size
    }
  }, children));
});
EuiTabs.displayName = 'EuiTabs';