"use strict";

var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTimelineItemIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _avatar = require("../avatar");
var _services = require("../../services");
var _timeline_item_icon = require("./timeline_item_icon.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiTimelineItemIcon = exports.EuiTimelineItemIcon = function EuiTimelineItemIcon(_ref) {
  var icon = _ref.icon,
    _ref$verticalAlign = _ref.verticalAlign,
    verticalAlign = _ref$verticalAlign === void 0 ? 'center' : _ref$verticalAlign,
    iconAriaLabel = _ref.iconAriaLabel;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _timeline_item_icon.euiTimelineItemIconStyles)(euiTheme);
  var cssStyles = [styles.euiTimelineItemIcon, styles[verticalAlign]];
  var cssContentStyles = styles.euiTimelineItemIcon__content;
  var ariaLabel = iconAriaLabel ? iconAriaLabel : '';
  var iconRender = /*#__PURE__*/(0, _react.isValidElement)(icon) ? icon : (0, _react2.jsx)(_avatar.EuiAvatar, {
    color: "subdued",
    name: ariaLabel,
    iconType: icon
  });
  return (0, _react2.jsx)("div", {
    css: cssStyles
  }, (0, _react2.jsx)("div", {
    css: cssContentStyles
  }, iconRender));
};