"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiGlobalToastListStyles = exports.euiGlobalToastListItemStyles = void 0;
var _taggedTemplateLiteral2 = _interopRequireDefault(require("@babel/runtime/helpers/taggedTemplateLiteral"));
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _templateObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiGlobalToastListStyles = exports.euiGlobalToastListStyles = function euiGlobalToastListStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiToastWidth = euiTheme.base * 25;
  return {
    /**
     * 1. Allow list to expand as items are added, but cap it at the screen height.
     * 2. Allow some padding for shadow
     */
    // Base
    euiGlobalToastList: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiScrollBarStyles)(euiThemeContext), " display:flex;flex-direction:column;align-items:stretch;position:fixed;z-index:", euiTheme.levels.toast, ";", (0, _global_styling.logicalCSS)('bottom', 0), " ", (0, _global_styling.logicalCSS)('width', "".concat(euiToastWidth, "px")), (0, _global_styling.logicalCSS)('max-height', '100vh'), (0, _global_styling.logicalCSSWithFallback)('overflow-y', 'auto'), "scrollbar-width:none;&::-webkit-scrollbar{", (0, _global_styling.logicalSizeCSS)(0, 0), ";}&:not(:empty){", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.base), ";}", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, 'm'), "{&:not(:empty){", (0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.logicalCSS)('width', '100%'), ";}};label:euiGlobalToastList;"),
    // Variants
    right: /*#__PURE__*/(0, _react.css)("&:not(:empty){", (0, _global_styling.logicalCSS)('right', 0), ";", (0, _global_styling.euiMinBreakpoint)(euiThemeContext, 'm'), "{", (0, _global_styling.logicalCSS)('padding-left', "".concat(euiTheme.base * 4, "px")), ";}};label:right;"),
    left: /*#__PURE__*/(0, _react.css)("&:not(:empty){", (0, _global_styling.logicalCSS)('left', 0), ";", (0, _global_styling.euiMinBreakpoint)(euiThemeContext, 'm'), "{", (0, _global_styling.logicalCSS)('padding-right', "".concat(euiTheme.base * 4, "px")), ";}};label:left;"),
    euiGlobalToastListDismissButton: /*#__PURE__*/(0, _react.css)("position:sticky;", (0, _global_styling.logicalCSS)('bottom', '0%'), ";;label:euiGlobalToastListDismissButton;")
  };
};
var euiGlobalToastListItemStyles = exports.euiGlobalToastListItemStyles = function euiGlobalToastListItemStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  var euiShowToast = (0, _react.keyframes)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  from {\n    transform: translateY(", ") scale(.9);\n    opacity: 0;\n  }\n\n  to {\n    transform: translateY(0) scale(1);\n    opacity: 1;\n  }\n"])), euiTheme.size.l);
  return {
    // Base
    euiGlobalToastListItem: /*#__PURE__*/(0, _react.css)("flex-shrink:0;", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.base), " animation:", euiTheme.animation.normal, " ", euiShowToast, " ", euiTheme.animation.resistance, ";opacity:1;&:first-child{", (0, _global_styling.logicalCSS)('margin-top', 'auto'), ";}&:last-child{", (0, _global_styling.logicalCSS)('margin-bottom', 0), ";};label:euiGlobalToastListItem;"),
    // States
    dismissed: /*#__PURE__*/(0, _react.css)("transition:opacity ", euiTheme.animation.normal, ";opacity:0;;label:dismissed;")
  };
};