"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToast = exports.COLORS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _accessibility = require("../accessibility");
var _button = require("../button");
var _i18n = require("../i18n");
var _icon = require("../icon");
var _text = require("../text");
var _toast = require("./toast.styles");
var _react2 = require("@emotion/react");
var _excluded = ["title", "color", "iconType", "onClose", "children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var COLORS = exports.COLORS = ['primary', 'success', 'warning', 'danger'];
var EuiToast = exports.EuiToast = function EuiToast(_ref) {
  var title = _ref.title,
    color = _ref.color,
    iconType = _ref.iconType,
    onClose = _ref.onClose,
    children = _ref.children,
    className = _ref.className,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var baseStyles = (0, _services.useEuiMemoizedStyles)(_toast.euiToastStyles);
  var baseCss = [baseStyles.euiToast, color && baseStyles[color]];
  var headerStyles = (0, _services.useEuiMemoizedStyles)(_toast.euiToastHeaderStyles);
  var headerCss = [headerStyles.euiToastHeader, children && headerStyles.withBody];
  var classes = (0, _classnames.default)('euiToast', className);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: baseCss,
    className: classes
  }, rest), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiToast.newNotification",
    default: "A new notification appears"
  }))), (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiToast.notification",
    default: "Notification"
  }, function (notification) {
    return (0, _react2.jsx)("div", {
      css: headerCss,
      "aria-label": notification,
      "data-test-subj": "euiToastHeader"
    }, iconType && (0, _react2.jsx)(_icon.EuiIcon, {
      css: headerStyles.euiToastHeader__icon,
      type: iconType,
      size: "m",
      "aria-hidden": "true"
    }), (0, _react2.jsx)("span", {
      css: headerStyles.euiToastHeader__title,
      "data-test-subj": "euiToastHeader__title"
    }, title));
  }), onClose && (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiToast.dismissToast",
    default: "Dismiss toast"
  }, function (dismissToast) {
    return (0, _react2.jsx)(_button.EuiButtonIcon, {
      css: baseStyles.euiToast__closeButton,
      iconType: "cross",
      color: "text",
      size: "xs",
      "aria-label": dismissToast,
      onClick: onClose,
      "data-test-subj": "toastCloseButton"
    });
  }), children && (0, _react2.jsx)(_text.EuiText, {
    size: "s",
    "data-test-subj": "euiToastBody"
  }, children));
};