"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToken = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _icon = require("../icon");
var _token_map = require("./token_map");
var _token_types = require("./token_types");
var _token = require("./token.styles");
var _react2 = require("@emotion/react");
var _excluded = ["iconType", "color", "fill", "shape", "size", "style", "className", "title", "aria-label", "aria-labelledby", "aria-describedby"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var isTokenColor = function isTokenColor(color) {
  return _token_types.COLORS.includes(color);
};
var EuiToken = exports.EuiToken = function EuiToken(_ref) {
  var iconType = _ref.iconType,
    color = _ref.color,
    fill = _ref.fill,
    shape = _ref.shape,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    _ref$style = _ref.style,
    style = _ref$style === void 0 ? {} : _ref$style,
    className = _ref.className,
    title = _ref.title,
    ariaLabel = _ref['aria-label'],
    ariaLabelledby = _ref['aria-labelledby'],
    ariaDescribedby = _ref['aria-describedby'],
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  // Set the icon size to the same as the passed size
  // unless they passed `xs` which IconSize doesn't support
  var finalSize = size === 'xs' ? 's' : size;

  // When displaying at the small size, the token specific icons
  // should actually be displayed at medium size
  if (typeof iconType === 'string' && iconType.indexOf('token') === 0 && size === 's') {
    finalSize = 'm';
  }

  // If the iconType passed is one of the prefab token types,
  // grab its properties
  var tokenDefaults = typeof iconType === 'string' && iconType in _token_map.TOKEN_MAP ? _token_map.TOKEN_MAP[iconType] : {};
  var finalColor = color || tokenDefaults.color || 'gray';
  var finalShape = shape || tokenDefaults.shape || 'circle';
  var finalFill = fill || 'light';
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _token.euiTokenStyles)(euiTheme, finalFill);
  var cssStyles = [styles.euiToken, styles[finalShape], styles[finalFill], styles[size]];
  var finalStyle = style;
  if (isTokenColor(finalColor)) {
    cssStyles = [].concat((0, _toConsumableArray2.default)(cssStyles), [styles[finalColor]]);
  } else if (finalFill === 'none') {
    // When a custom HEX color is passed and the token doesn't have any fill (no background),
    // the icon gets that passed color
    cssStyles = [].concat((0, _toConsumableArray2.default)(cssStyles), [styles.customColor]);
    finalStyle = _objectSpread({
      color: finalColor
    }, style);
  } else {
    // When a custom HEX color is passed and the token has a fill (light or dark),
    // the background gets the custom color and the icon gets white or black based on the passed color
    // The fill='light' (lightened background) will always be overridden by fill='dark' (opaque background)
    // to better handle custom colors
    var isFinalColorDark = _services.isColorDark.apply(void 0, (0, _toConsumableArray2.default)((0, _services.hexToRgb)(finalColor)));
    var lightOrDarkColor = isFinalColorDark ? '#FFFFFF' : '#000000';
    cssStyles = [].concat((0, _toConsumableArray2.default)(cssStyles), [styles.customColor]);
    finalFill = 'dark';
    finalStyle = _objectSpread({
      color: lightOrDarkColor,
      backgroundColor: finalColor
    }, style);
  }
  var classes = (0, _classnames.default)('euiToken', className);
  return (0, _react2.jsx)("span", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    style: finalStyle
  }, rest), (0, _react2.jsx)(_icon.EuiIcon, {
    type: iconType,
    size: finalSize,
    title: title,
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledby,
    "aria-describedby": ariaDescribedby
  }));
};