"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiTokenStyles = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _react = require("@emotion/react");
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _global_styling = require("../../global_styling");
var _services = require("../../services");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var visColors = (0, _services.euiPaletteColorBlind)();
var visColorsBehindText = (0, _services.euiPaletteColorBlindBehindText)();
var getTokenColor = function getTokenColor(euiTheme, colorMode, fill, color) {
  var isVizColor = typeof color === 'number';
  var iconColor = isVizColor ? visColors[color] : euiTheme.colors.darkShade;
  var isDarkMode = colorMode === 'DARK';
  var backgroundDarkColor = isVizColor ? visColorsBehindText[color] : euiTheme.colors.darkShade;
  var backgroundLightColor = isDarkMode ? (0, _services.shade)(iconColor, 0.7) : (0, _services.tint)(iconColor, 0.9);
  var lightColor = (0, _services.makeHighContrastColor)(iconColor)(backgroundLightColor);
  var boxShadowColor = isDarkMode ? (0, _services.shade)(iconColor, 0.6) : (0, _services.tint)(iconColor, 0.7);
  var darkColor = _services.isColorDark.apply(void 0, (0, _toConsumableArray2.default)((0, _chromaJs.default)(backgroundDarkColor).rgb())) ? euiTheme.colors.ghost : euiTheme.colors.ink;
  switch (fill) {
    case 'none':
      return "\n        // Without a background, the fill color should be the graphic color\n        color: ".concat(iconColor, ";\n      ");
    case 'light':
      return "\n        color: ".concat(lightColor, ";\n        background-color: ").concat(backgroundLightColor, ";\n        box-shadow: inset 0 0 0 1px ").concat(boxShadowColor, ";\n      ");
    case 'dark':
      return "\n        color: ".concat(darkColor, ";\n        background-color: ").concat(backgroundDarkColor, ";\n      ");
  }
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1ab5xb2-circle",
  styles: "border-radius:50%;label:circle;"
} : {
  name: "1ab5xb2-circle",
  styles: "border-radius:50%;label:circle;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiTokenStyles = exports.euiTokenStyles = function euiTokenStyles(_ref2, fill) {
  var euiTheme = _ref2.euiTheme,
    colorMode = _ref2.colorMode;
  return {
    // Base
    euiToken: /*#__PURE__*/(0, _react.css)("display:inline-flex;align-items:center;justify-content:center;svg{", (0, _global_styling.logicalCSS)('height', '100%'), " margin:auto;};label:euiToken;"),
    // Shapes
    circle: _ref,
    square: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.small, ";;label:square;"),
    rectangle: /*#__PURE__*/(0, _react.css)("box-sizing:content-box;border-radius:", euiTheme.border.radius.small, ";;label:rectangle;"),
    // Sizes
    xs: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.s), " &[class*='-square'],&[class*='-rectangle']{border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.small, function (x) {
      return x / 2;
    }), ";}&[class*='-rectangle']{", (0, _global_styling.logicalCSS)('padding-vertical', '1px'), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), ";};label:xs;"),
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.base), " &[class*='-rectangle']{", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), ";};label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.l), " &[class*='-rectangle']{", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.s), ";};label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.xl), " &[class*='-rectangle']{", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.s), ";};label:l;"),
    // Colors
    euiColorVis0: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 0), ";label:euiColorVis0;"),
    euiColorVis1: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 1), ";label:euiColorVis1;"),
    euiColorVis2: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 2), ";label:euiColorVis2;"),
    euiColorVis3: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 3), ";label:euiColorVis3;"),
    euiColorVis4: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 4), ";label:euiColorVis4;"),
    euiColorVis5: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 5), ";label:euiColorVis5;"),
    euiColorVis6: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 6), ";label:euiColorVis6;"),
    euiColorVis7: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 7), ";label:euiColorVis7;"),
    euiColorVis8: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 8), ";label:euiColorVis8;"),
    euiColorVis9: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 9), ";label:euiColorVis9;"),
    gray: /*#__PURE__*/(0, _react.css)(getTokenColor(euiTheme, colorMode, fill, 'gray'), ";label:gray;"),
    customColor: /*#__PURE__*/(0, _react.css)(";label:customColor;"),
    // Fills
    light: /*#__PURE__*/(0, _react.css)(";label:light;"),
    dark: /*#__PURE__*/(0, _react.css)(";label:dark;"),
    none: /*#__PURE__*/(0, _react.css)(";label:none;")
  };
};