"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToolTipAnchor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _tool_tip = require("./tool_tip.styles");
var _react2 = require("@emotion/react");
var _excluded = ["onBlur", "onFocus", "onMouseOver", "onMouseOut", "id", "className", "children", "display", "isVisible"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiToolTipAnchor = exports.EuiToolTipAnchor = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _onBlur = _ref.onBlur,
    _onFocus = _ref.onFocus,
    onMouseOver = _ref.onMouseOver,
    onMouseOut = _ref.onMouseOut,
    id = _ref.id,
    className = _ref.className,
    children = _ref.children,
    display = _ref.display,
    isVisible = _ref.isVisible,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var anchorCss = (0, _tool_tip.euiToolTipAnchorStyles)();
  var cssStyles = [anchorCss.euiToolTipAnchor, anchorCss[display]];
  var classes = (0, _classnames.default)('euiToolTipAnchor', className);
  return (
    // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
    (0, _react2.jsx)("span", (0, _extends2.default)({
      ref: ref,
      css: cssStyles
    }, rest, {
      className: classes,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut
    }), /*#__PURE__*/(0, _react.cloneElement)(children, {
      onFocus: function onFocus(e) {
        _onFocus();
        children.props.onFocus && children.props.onFocus(e);
      },
      onBlur: function onBlur(e) {
        _onBlur();
        children.props.onBlur && children.props.onBlur(e);
      },
      'aria-describedby': isVisible ? (0, _classnames.default)(id, children.props['aria-describedby']) : children.props['aria-describedby']
    }))
  );
});
EuiToolTipAnchor.displayName = 'EuiToolTipAnchor';