"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolTipManager = void 0;
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Manager utility that ensures only one tooltip is visible at a time
 *
 * UX rationale (primarily for mouse-only users):
 * @see https://github.com/elastic/kibana/issues/144482
 * @see https://github.com/elastic/eui/issues/5883
 */
var ToolTipManager = /*#__PURE__*/(0, _createClass2.default)(function ToolTipManager() {
  var _this = this;
  (0, _classCallCheck2.default)(this, ToolTipManager);
  // We use a set instead of a single var just in case
  // multiple tooltips are registered via async shenanigans
  (0, _defineProperty2.default)(this, "toolTipsToHide", new Set());
  (0, _defineProperty2.default)(this, "registerTooltip", function (hideCallback) {
    _this.toolTipsToHide.forEach(function (hide) {
      return hide();
    });
    _this.toolTipsToHide.clear();
    _this.toolTipsToHide.add(hideCallback);
  });
  (0, _defineProperty2.default)(this, "deregisterToolTip", function (hideCallback) {
    _this.toolTipsToHide.delete(hideCallback);
  });
});
var toolTipManager = exports.toolTipManager = new ToolTipManager();