"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToolTipPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _tool_tip = require("./tool_tip.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "title", "className", "positionToolTip", "popoverRef", "calculatedPosition"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiToolTipPopover = exports.EuiToolTipPopover = function EuiToolTipPopover(_ref) {
  var children = _ref.children,
    title = _ref.title,
    className = _ref.className,
    positionToolTip = _ref.positionToolTip,
    popoverRef = _ref.popoverRef,
    calculatedPosition = _ref.calculatedPosition,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var popover = (0, _react.useRef)();
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _tool_tip.euiToolTipStyles)(euiTheme);
  var cssStyles = [styles.euiToolTip, calculatedPosition && styles[calculatedPosition]];
  var updateDimensions = (0, _react.useCallback)(function () {
    requestAnimationFrame(function () {
      // Because of this delay, sometimes `positionToolTip` becomes unavailable.
      if (popover.current) {
        positionToolTip();
      }
    });
  }, [positionToolTip]);
  var setPopoverRef = function setPopoverRef(ref) {
    if (popoverRef) {
      popoverRef(ref);
    }
  };
  (0, _react.useEffect)(function () {
    document.body.classList.add('euiBody-hasPortalContent');
    window.addEventListener('resize', updateDimensions);
    return function () {
      document.body.classList.remove('euiBody-hasPortalContent');
      window.removeEventListener('resize', updateDimensions);
    };
  }, [updateDimensions]);
  var classes = (0, _classnames.default)('euiToolTipPopover', className);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes,
    ref: setPopoverRef,
    "data-position": calculatedPosition
  }, rest), title && (0, _react2.jsx)("div", {
    css: styles.euiToolTip__title,
    className: "euiToolTip__title"
  }, title), children);
};