"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourFooter = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _popover = require("../popover");
var _button = require("../button");
var _flex = require("../flex");
var _tour_step_indicator = require("./tour_step_indicator");
var _tour_footer = require("./_tour_footer.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiTourFooter = exports.EuiTourFooter = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var footerAction = _ref.footerAction,
    step = _ref.step,
    stepsTotal = _ref.stepsTotal,
    onFinish = _ref.onFinish;
  var footerStyles = (0, _services.useEuiMemoizedStyles)(_tour_footer.euiTourFooterStyles);
  var customFooterAction = (0, _react.useMemo)(function () {
    if (!footerAction) return null;
    return Array.isArray(footerAction) ? (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "flexEnd",
      responsive: false,
      wrap: true
    }, footerAction.map(function (action, index) {
      return (0, _react2.jsx)(_flex.EuiFlexItem, {
        key: index,
        grow: false
      }, action);
    })) : (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, footerAction);
  }, [footerAction]);
  var indicators = (0, _react.useMemo)(function () {
    if (stepsTotal <= 1) return null;
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)("ul", {
      className: "euiTourFooter__stepList"
    }, (0, _toConsumableArray2.default)(Array(stepsTotal).keys()).map(function (_, i) {
      var status = 'complete';
      if (step === i + 1) {
        status = 'active';
      } else if (step <= i) {
        status = 'incomplete';
      }
      return (0, _react2.jsx)(_tour_step_indicator.EuiTourStepIndicator, {
        key: i,
        number: i + 1,
        status: status
      });
    })));
  }, [step, stepsTotal]);
  return (0, _react2.jsx)(_popover.EuiPopoverFooter, {
    css: footerStyles.euiTourFooter,
    className: "euiTourFooter"
  }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    responsive: false,
    justifyContent: stepsTotal > 1 ? 'spaceBetween' : 'flexEnd',
    alignItems: "center"
  }, indicators, footerAction ? customFooterAction : (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiTourFooter.endTour', 'euiTourFooter.skipTour', 'euiTourFooter.closeTour'],
    defaults: ['End tour', 'Skip tour', 'Close tour']
  }, function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 3),
      endTour = _ref3[0],
      skipTour = _ref3[1],
      closeTour = _ref3[2];
    return (0, _react2.jsx)(_button.EuiButtonEmpty, {
      onClick: onFinish,
      color: "text",
      flush: "right",
      size: "xs"
    }, stepsTotal > 1 ? stepsTotal === step ? endTour : skipTour : closeTour);
  }))));
});
EuiTourFooter.displayName = '_EuiTourFooter';