"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourStepIndicator = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = require("@emotion/react");
var _icon = require("../icon");
var _i18n = require("../i18n");
var _excluded = ["className", "number", "status"];
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1v4nm53-EuiTourStepIndicator",
  styles: "display:inline-block;label:EuiTourStepIndicator;"
} : {
  name: "1v4nm53-EuiTourStepIndicator",
  styles: "display:inline-block;label:EuiTourStepIndicator;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var EuiTourStepIndicator = exports.EuiTourStepIndicator = function EuiTourStepIndicator(_ref2) {
  var className = _ref2.className,
    number = _ref2.number,
    status = _ref2.status,
    rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
  var classes = (0, _classnames.default)('euiTourStepIndicator', className);
  var indicatorIcon;
  if (status === 'active') {
    indicatorIcon = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiTourStepIndicator.isActive",
      default: "active"
    }, function (isActive) {
      return (0, _react2.jsx)(_icon.EuiIcon, {
        type: "dot",
        "aria-label": isActive,
        color: "success",
        "aria-current": "step"
      });
    });
  } else if (status === 'complete') {
    indicatorIcon = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiTourStepIndicator.isComplete",
      default: "complete"
    }, function (isComplete) {
      return (0, _react2.jsx)(_icon.EuiIcon, {
        type: "dot",
        "aria-label": isComplete,
        color: "subdued"
      });
    });
  } else if (status === 'incomplete') {
    indicatorIcon = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiTourStepIndicator.isIncomplete",
      default: "incomplete"
    }, function (isIncomplete) {
      return (0, _react2.jsx)(_icon.EuiIcon, {
        type: "dot",
        "aria-label": isIncomplete,
        color: "subdued"
      });
    });
  }
  return (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiTourStepIndicator.ariaLabel",
    default: "Step {number} {status}",
    values: {
      status: status,
      number: number
    }
  }, function (ariaLabel) {
    return (0, _react2.jsx)("li", (0, _extends2.default)({
      css: _ref,
      className: classes,
      "aria-label": ariaLabel
    }, rest), indicatorIcon);
  });
};