"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logicals = exports.logicalTextAlignStyle = exports.logicalTextAlignCSS = exports.logicalText = exports.logicalStyles = exports.logicalStyle = exports.logicalSizeStyle = exports.logicalSizeCSS = exports.logicalSide = exports.logicalCSSWithFallback = exports.logicalCSS = exports.LOGICAL_TEXT_ALIGNMENT = exports.LOGICAL_SIDES = exports.LOGICAL_PROPERTIES = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _common = require("../../components/common");
var _logicals2 = _interopRequireDefault(require("./logicals.json"));
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * EUI utilizes logical CSS properties to enable directional writing-modes.
 * To encourage use of logical properties, we provide a few helper utilities to
 * convert certain directional properties to logical properties.
 * https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Logical_Properties
 */

var logicalSide = exports.logicalSide = {
  left: 'inline-start',
  right: 'inline-end',
  top: 'block-start',
  bottom: 'block-end',
  horizontal: 'inline',
  vertical: 'block'
};
var LOGICAL_SIDES = exports.LOGICAL_SIDES = (0, _common.keysOf)(logicalSide);
var logicals = exports.logicals = _logicals2.default;
var _shorthands = _logicals2.default._shorthands,
  _logicals = (0, _objectWithoutProperties2.default)(_logicals2.default, ["_shorthands"]);
var LOGICAL_PROPERTIES = exports.LOGICAL_PROPERTIES = (0, _common.keysOf)(_logicals);
/**
 *
 * @param property A string that is a valid CSS logical property
 * @param value String to output as the property value
 * @returns `string` Returns the logical CSS property version for the given `property: value` pair
 */
var logicalCSS = exports.logicalCSS = function logicalCSS(property, value) {
  return "".concat(logicals[property], ": ").concat(value, ";");
};

/**
 * Some logical properties are not yet fully supported by all browsers.
 * For those cases, we should use the old property as a fallback for
 * browsers missing support, while allowing supporting browsers to use
 * the logical properties.
 *
 * Examples:
 * https://caniuse.com/?search=overflow-block
 * https://caniuse.com/mdn-css_properties_float_flow_relative_values
 */
var logicalCSSWithFallback = exports.logicalCSSWithFallback = function logicalCSSWithFallback(property, value) {
  return "\n  ".concat(property, ": ").concat(value, ";\n  ").concat(logicalCSS(property, value), "\n");
};

/**
 * Casing utils for swapping between camel case (style objs) and kebab case (CSS)
 */
var camelCase = function camelCase(kebabCasedString) {
  return kebabCasedString.replace(/-\w/g, function (str) {
    return str.charAt(1).toUpperCase();
  });
};
var kebabCase = function kebabCase(camelCasedString) {
  return camelCasedString.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
};

/**
 *
 * @param property A string that is a valid CSS logical property
 * @param value String to output as the property value
 * @returns `object` Returns the logical CSS property version for the given `property: value` pair
 */
var logicalStyle = exports.logicalStyle = function logicalStyle(property, value) {
  return (0, _defineProperty2.default)({}, camelCase(logicals[property]), value);
};

/**
 * Given a style object with any amount of unknown CSS properties,
 * find ones that can be converted to logical properties and convert them
 *
 * @param styleObject - A React object of camelCased styles
 * @returns `object`
 */
var logicalStyles = exports.logicalStyles = function logicalStyles(styleObject) {
  var logicalStyleObject = {};
  Object.entries(styleObject).forEach(function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
      key = _ref3[0],
      value = _ref3[1];
    var cssProperty = kebabCase(key);
    if (logicals.hasOwnProperty(cssProperty)) {
      var logicalKey = camelCase(logicals[cssProperty]);
      logicalStyleObject[logicalKey] = value;
    } else {
      logicalStyleObject[key] = value;
    }
  });
  return logicalStyleObject;
};

/**
 *
 * @param width A string value for the LTR width
 * @param height A string value for the LTR height
 * @returns `string` Returns the logical CSS properties for height and width
 */
var logicalSizeCSS = exports.logicalSizeCSS = function logicalSizeCSS(width) {
  var height = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : width;
  return "\n    ".concat(logicals.width, ": ").concat(width, ";\n    ").concat(logicals.height, ": ").concat(height, ";\n  ");
};

/**
 *
 * @param width A string value for the LTR width
 * @param height A string value for the LTR height
 * @returns `object` Returns the logical CSS properties for height and width
 */
var logicalSizeStyle = exports.logicalSizeStyle = function logicalSizeStyle(width, height) {
  return _objectSpread(_objectSpread({}, logicalStyle('width', width)), logicalStyle('height', height));
};

// Text alignment is separate because its the value that changes not the property
var logicalText = exports.logicalText = {
  'text-align': {
    left: 'start',
    center: 'center',
    right: 'end'
  }
};
var LOGICAL_TEXT_ALIGNMENT = exports.LOGICAL_TEXT_ALIGNMENT = (0, _common.keysOf)(logicalText['text-align']);
/**
 *
 * @param property A string that is a valid CSS logical property
 * @param value String to output as the property value
 * @returns `string` Returns the logical CSS property version for the given `property: value` pair
 */
var logicalTextAlignCSS = exports.logicalTextAlignCSS = function logicalTextAlignCSS(value) {
  return "text-align: ".concat(logicalText['text-align'][value], ";");
};

/**
 *
 * @param property A string that is a valid CSS logical property
 * @param value String to output as the property value
 * @returns `object` Returns the logical CSS property version for the given `property: value` pair
 */
var logicalTextAlignStyle = exports.logicalTextAlignStyle = function logicalTextAlignStyle(value) {
  return {
    textAlign: logicalText['text-align'][value]
  };
};