"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mathWithUnits = void 0;
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _setPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/setPrototypeOf"));
function _wrapRegExp() { _wrapRegExp = function _wrapRegExp(e, r) { return new BabelRegExp(e, void 0, r); }; var e = RegExp.prototype, r = new WeakMap(); function BabelRegExp(e, t, p) { var o = RegExp(e, t); return r.set(o, p || r.get(e)), (0, _setPrototypeOf2.default)(o, BabelRegExp.prototype); } function buildGroups(e, t) { var p = r.get(t); return Object.keys(p).reduce(function (r, t) { var o = p[t]; if ("number" == typeof o) r[t] = e[o];else { for (var i = 0; void 0 === e[o[i]] && i + 1 < o.length;) i++; r[t] = e[o[i]]; } return r; }, Object.create(null)); } return (0, _inherits2.default)(BabelRegExp, RegExp), BabelRegExp.prototype.exec = function (r) { var t = e.exec.call(this, r); if (t) { t.groups = buildGroups(t, this); var p = t.indices; p && (p.groups = buildGroups(p, this)); } return t; }, BabelRegExp.prototype[Symbol.replace] = function (t, p) { if ("string" == typeof p) { var o = r.get(this); return e[Symbol.replace].call(this, t, p.replace(/\$<([^>]+)>/g, function (e, r) { var t = o[r]; return "$" + (Array.isArray(t) ? t.join("$") : t); })); } if ("function" == typeof p) { var i = this; return e[Symbol.replace].call(this, t, function () { var e = arguments; return "object" != _typeof(e[e.length - 1]) && (e = [].slice.call(e)).push(buildGroups(e, i)), p.apply(this, e); }); } return e[Symbol.replace].call(this, t, p); }, _wrapRegExp.apply(this, arguments); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Utility for performing math callbacks on a string with CSS units
 * and returning a string with its unit preserved.
 *
 * Example usage:
 * mathWithUnits('4px', (x) => x / 2) = '2px';
 * mathWithUnits(euiTheme.size.xs, (x) => x + 2) = '6px';
 * mathWithUnits([euiTheme.size.l, euiTheme.size.s], (x, y) => x - y) = '16px';
 */
// Unfortunately, this is the CSSProperties[] type used for several euiTheme vars

var mathWithUnits = exports.mathWithUnits = function mathWithUnits(values, callback) {
  var unit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  if (!Array.isArray(values)) values = [values];
  var foundNumericValues = [];
  var foundUnit = '';
  values.forEach(function (value) {
    if (typeof value === 'string') {
      var _matches$groups, _matches$groups2;
      var regex = /*#__PURE__*/_wrapRegExp(/(\x2D?[\d.]+)(%|[a-zA-Z]*)/, {
        value: 1,
        unit: 2
      });
      var matches = regex.exec(value);
      var numericValue = Number(matches === null || matches === void 0 || (_matches$groups = matches.groups) === null || _matches$groups === void 0 ? void 0 : _matches$groups.value);
      if (!isNaN(numericValue)) {
        foundNumericValues.push(numericValue);
      } else {
        throw new Error('No valid numeric value found');
      }
      if (!unit && matches !== null && matches !== void 0 && (_matches$groups2 = matches.groups) !== null && _matches$groups2 !== void 0 && _matches$groups2.unit) {
        if (!foundUnit) {
          foundUnit = matches.groups.unit;
        } else if (foundUnit !== matches.groups.unit) {
          throw new Error('Multiple units found. Use `calc()` to mix and math multiple unit types (e.g. `%` & `px`) instead');
        }
      }
    } else if (typeof value === 'number') {
      foundNumericValues.push(value);
    } else {
      throw new Error('Invalid value type - pass a string or number');
    }
  });
  return "".concat(callback.apply(void 0, foundNumericValues)).concat(unit || foundUnit);
};