"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiGlobalStyles = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectDestructuringEmpty2 = _interopRequireDefault(require("@babel/runtime/helpers/objectDestructuringEmpty"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _mixins = require("../mixins");
var _functions = require("../functions");
var _color = require("../../services/color");
var _theme = require("../../services/theme");
var _reset = require("./reset");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiGlobalStyles = exports.EuiGlobalStyles = function EuiGlobalStyles(_ref) {
  (0, _objectDestructuringEmpty2.default)(_ref);
  var euiThemeContext = (0, _theme.useEuiTheme)();
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var base = euiTheme.base,
    colors = euiTheme.colors,
    font = euiTheme.font;

  /**
   * Declaring the top level scrollbar colors to match the theme also requires setting the sizes on Chrome
   * so that it knows to use custom styles. Therefore, we just reuse the same scrollbar mixin with thick size.
   */
  var scrollbarStyles = (0, _mixins.euiScrollBarStyles)(euiThemeContext, {
    trackColor: colorMode === 'LIGHT' ? (0, _color.shade)(colors.body, 0.03) : (0, _color.tint)(colors.body, 0.07),
    width: 'auto'
  });

  /**
   * This font reset sets all our base font/typography related properties
   * that are needed to override browser-specific element settings.
   */
  var fontBodyScale = font.scale[font.body.scale];
  var fontReset = {
    fontFamily: font.family,
    fontSize: "".concat(font.defaultUnits === 'px' ? fontBodyScale * base : fontBodyScale).concat(font.defaultUnits),
    lineHeight: base / (fontBodyScale * base),
    fontWeight: font.weight[font.body.weight]
  };

  /**
   * Final styles
   */
  var styles = /*#__PURE__*/(0, _react2.css)(_reset.resetStyles, " html{", scrollbarStyles, " ", fontReset, " text-size-adjust:100%;font-kerning:normal;", (0, _functions.logicalCSS)('height', '100%'), " background-color:", colors.body, ";color:", colors.text, ";}code,pre,kbd,samp{font-family:", font.familyCode, ";}input,textarea,select{", _objectSpread(_objectSpread({}, fontReset), {}, {
    fontSize: '1rem' // Inherit from html root
  }), ";}select:disabled{opacity:1;}button{font-family:", font.family, ";}em{font-style:italic;}strong{font-weight:", font.weight.bold, ";}*:focus{", (0, _mixins.euiFocusRing)(euiThemeContext), ";}::selection{background:", (0, _color.transparentize)(colors.primary, colorMode === 'LIGHT' ? 0.1 : 0.2), ";}a{color:", colors.primaryText, ";&,&:hover,&:focus{text-decoration:none;}}.euiBody-hasPortalContent{position:relative;};label:styles;");
  return (0, _react2.jsx)(_react2.Global, {
    styles: styles
  });
};