"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalStyles = exports.EuiUtilityClasses = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _hooks = require("../../services/theme/hooks");
var _screen_reader_only = require("../../components/accessibility/screen_reader_only/screen_reader_only.styles");
var _mixins = require("../mixins");
var _functions = require("../functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var globalStyles = exports.globalStyles = function globalStyles(euiThemeContext) {
  return /*#__PURE__*/(0, _react2.css)(".euiScreenReaderOnly{", (0, _screen_reader_only.euiScreenReaderOnly)(), ";}.eui-alignBaseline{vertical-align:baseline!important;}.eui-alignBottom{vertical-align:bottom!important;}.eui-alignMiddle{vertical-align:middle!important;}.eui-alignTop{vertical-align:top!important;}.eui-displayBlock{display:block!important;}.eui-displayInline{display:inline!important;}.eui-displayInlineBlock{display:inline-block!important;}.eui-fullWidth{display:block!important;", (0, _functions.logicalCSS)('width', '100% !important'), ";}.eui-fullHeight{", (0, _mixins.euiFullHeight)(), ";}.eui-textCenter{text-align:center!important;}.eui-textLeft{text-align:start!important;}.eui-textRight{text-align:end!important;}.eui-textNoWrap{white-space:nowrap!important;}.eui-textInheritColor{color:inherit!important;}.eui-textBreakWord{", (0, _mixins.euiTextBreakWord)(), ";}.eui-textBreakAll{overflow-wrap:break-word!important;word-break:break-all!important;}.eui-textBreakNormal{overflow-wrap:normal!important;word-wrap:normal!important;word-break:normal!important;}.eui-textTruncate{", (0, _mixins.euiTextTruncate)(), ";}.eui-textNumber{", (0, _mixins.euiNumberFormat)(euiThemeContext), ";}.eui-scrollBar{", (0, _mixins.euiScrollBarStyles)(euiThemeContext), ";}.eui-yScroll{", (0, _mixins.euiYScroll)(euiThemeContext), ";}.eui-xScroll{", (0, _mixins.euiXScroll)(euiThemeContext), ";}.eui-yScrollWithShadows{", (0, _mixins.euiYScrollWithShadows)(euiThemeContext), ";}.eui-xScrollWithShadows{", (0, _mixins.euiXScrollWithShadows)(euiThemeContext), ";}[class*='eui-showFor']{display:none!important;}", Object.keys(euiThemeContext.euiTheme.breakpoint).map(function (size) {
    return "\n      .eui-hideFor--".concat(size, " {\n        ").concat((0, _mixins.euiBreakpoint)(euiThemeContext, [size]), " {\n          display: none !important;\n        }\n      }\n      .eui-showFor--").concat(size, " {\n        ").concat((0, _mixins.euiBreakpoint)(euiThemeContext, [size]), " {\n          display: inline !important;\n        }\n      }\n      .eui-showFor--").concat(size, "--block {\n        ").concat((0, _mixins.euiBreakpoint)(euiThemeContext, [size]), " {\n          display: block !important;\n        }\n      }\n      .eui-showFor--").concat(size, "--inlineBlock {\n        ").concat((0, _mixins.euiBreakpoint)(euiThemeContext, [size]), " {\n          display: inline-block !important;\n        }\n      }\n      .eui-showFor--").concat(size, "--flex {\n        ").concat((0, _mixins.euiBreakpoint)(euiThemeContext, [size]), " {\n          display: flex !important;\n        }\n      }");
  }), ";;label:globalStyles;");
};
var EuiUtilityClasses = exports.EuiUtilityClasses = function EuiUtilityClasses() {
  var euiTheme = (0, _hooks.useEuiTheme)();
  return (0, _react2.jsx)(_react2.Global, {
    styles: globalStyles(euiTheme)
  });
};