"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeepEqual = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
var _useUpdateEffect = require("./useUpdateEffect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This hook is mostly a performance concern for third-party objs/arrays that EUI
 * has no control over and may not be correctly memoized (i.e., will create a new
 * reference on every rerender unless passed through this hook).
 */
var useDeepEqual = exports.useDeepEqual = function useDeepEqual(object) {
  var _useState = (0, _react.useState)(object),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    memoizedObject = _useState2[0],
    setMemoizedObject = _useState2[1];
  (0, _useUpdateEffect.useUpdateEffect)(function () {
    if (!(0, _isEqual.default)(object, memoizedObject)) {
      setMemoizedObject(object);
    }
  }, [object]);
  return memoizedObject;
};