"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForEuiToolTipVisible = exports.waitForEuiToolTipHidden = exports.waitForEuiPopoverOpen = exports.waitForEuiPopoverClose = exports.waitForEuiContextMenuPanelTransition = exports.showEuiComboBoxOptions = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
require("@testing-library/jest-dom");
var _react = require("@testing-library/react");
var _custom_render = require("./custom_render");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Ensure the EuiPopover being tested is open/closed before continuing
 * Note: Because EuiPopover is portalled, we want to query `document`
 * instead of the `container` returned by RTL's render()
 */
var waitForEuiPopoverOpen = exports.waitForEuiPopoverOpen = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return (0, _react.waitFor)(function () {
            var openPopover = document.querySelector('[data-popover-open]');
            expect(openPopover).toBeTruthy();
          });
        case 2:
          return _context.abrupt("return", _context.sent);
        case 3:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function waitForEuiPopoverOpen() {
    return _ref.apply(this, arguments);
  };
}();
var waitForEuiPopoverClose = exports.waitForEuiPopoverClose = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
    return _regenerator.default.wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return (0, _react.waitFor)(function () {
            var openPopover = document.querySelector('[data-popover-open]');
            expect(openPopover).toBeFalsy();
          });
        case 2:
          return _context2.abrupt("return", _context2.sent);
        case 3:
        case "end":
          return _context2.stop();
      }
    }, _callee2);
  }));
  return function waitForEuiPopoverClose() {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * Ensure the EuiToolTip being tested is open and visible before continuing
 */
var waitForEuiToolTipVisible = exports.waitForEuiToolTipVisible = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3() {
    return _regenerator.default.wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return (0, _react.waitFor)(function () {
            var tooltip = document.querySelector('.euiToolTipPopover');
            expect(tooltip).toBeVisible();
          }, {
            timeout: 3000
          } // Account for long delay on tooltips
          );
        case 2:
          return _context3.abrupt("return", _context3.sent);
        case 3:
        case "end":
          return _context3.stop();
      }
    }, _callee3);
  }));
  return function waitForEuiToolTipVisible() {
    return _ref3.apply(this, arguments);
  };
}();
var waitForEuiToolTipHidden = exports.waitForEuiToolTipHidden = /*#__PURE__*/function () {
  var _ref4 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4() {
    return _regenerator.default.wrap(function _callee4$(_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return (0, _react.waitFor)(function () {
            var tooltip = document.querySelector('.euiToolTipPopover');
            expect(tooltip).toBeNull();
          });
        case 2:
          return _context4.abrupt("return", _context4.sent);
        case 3:
        case "end":
          return _context4.stop();
      }
    }, _callee4);
  }));
  return function waitForEuiToolTipHidden() {
    return _ref4.apply(this, arguments);
  };
}();

/**
 * EuiComboBox
 */

var showEuiComboBoxOptions = exports.showEuiComboBoxOptions = /*#__PURE__*/function () {
  var _ref5 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee5() {
    return _regenerator.default.wrap(function _callee5$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          _react.fireEvent.click(_custom_render.screen.getByTestSubject('comboBoxToggleListButton'));
          _context5.next = 3;
          return waitForEuiPopoverOpen();
        case 3:
          _context5.next = 5;
          return (0, _react.waitFor)(function () {
            expect(_custom_render.screen.getByRole('listbox')).toBeInTheDocument();
          });
        case 5:
        case "end":
          return _context5.stop();
      }
    }, _callee5);
  }));
  return function showEuiComboBoxOptions() {
    return _ref5.apply(this, arguments);
  };
}();

/**
 * EuiContextMenu
 */

var waitForEuiContextMenuPanelTransition = exports.waitForEuiContextMenuPanelTransition = /*#__PURE__*/function () {
  var _ref6 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee6() {
    var getPanels;
    return _regenerator.default.wrap(function _callee6$(_context6) {
      while (1) switch (_context6.prev = _context6.next) {
        case 0:
          // Used document instead of container or screen due to context menus living in portals
          getPanels = function getPanels() {
            return document.querySelectorAll('.euiContextMenuPanel');
          }; // 2 panels will appear for the transition animation
          _context6.next = 3;
          return (0, _react.waitFor)(function () {
            expect(getPanels().length).toEqual(2);
          });
        case 3:
          // Outgoing panel will be removed on animation end
          _react.fireEvent.animationEnd(getPanels()[0]);
          if (getPanels().length > 1) {
            _react.fireEvent.animationEnd(getPanels()[1]);
          }

          // Transition/animation is done once we're back to 1 panel
          expect(getPanels().length).toEqual(1);
        case 6:
        case "end":
          return _context6.stop();
      }
    }, _callee6);
  }));
  return function waitForEuiContextMenuPanelTransition() {
    return _ref6.apply(this, arguments);
  };
}();