"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiScreenReaderLive = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _screen_reader_only = require("../screen_reader_only");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiScreenReaderLive = exports.EuiScreenReaderLive = function EuiScreenReaderLive(_ref) {
  var children = _ref.children,
    _ref$isActive = _ref.isActive,
    isActive = _ref$isActive === void 0 ? true : _ref$isActive,
    _ref$role = _ref.role,
    role = _ref$role === void 0 ? 'status' : _ref$role,
    _ref$ariaLive = _ref['aria-live'],
    ariaLive = _ref$ariaLive === void 0 ? 'polite' : _ref$ariaLive,
    _ref$focusRegionOnTex = _ref.focusRegionOnTextChange,
    focusRegionOnTextChange = _ref$focusRegionOnTex === void 0 ? false : _ref$focusRegionOnTex;
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    toggle = _useState2[0],
    setToggle = _useState2[1];
  var focusRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    setToggle(function (toggle) {
      return !toggle;
    });
  }, [children]);
  (0, _react.useEffect)(function () {
    if (focusRef.current !== null && focusRegionOnTextChange) {
      focusRef.current.focus();
    }
  }, [toggle, focusRegionOnTextChange]);
  return (
    /**
     * Intentionally uses two persistent live regions with oscillating content updates.
     * This resolves the problem of duplicate screen reader announcements in rapid succession
     * caused by React's virtual DOM behaviour (https://github.com/nvaccess/nvda/issues/7996#issuecomment-413641709)
     *
     * Adapted from https://github.com/alphagov/accessible-autocomplete/blob/a7106f03150941fc15e6c1ceb0a90e8872fa86ef/src/status.js
     * Debouncing was not needed for this case, but could prove to be useful for future use cases.
     * See also https://github.com/AlmeroSteyn/react-aria-live and https://github.com/dequelabs/ngA11y
     * for more examples of the double region approach.
     */
    (0, _react2.jsx)(_screen_reader_only.EuiScreenReaderOnly, null, (0, _react2.jsx)("div", {
      ref: focusRef,
      tabIndex: focusRegionOnTextChange ? -1 : undefined
    }, (0, _react2.jsx)("div", {
      role: role,
      "aria-atomic": "true"
      // Setting `aria-hidden` and setting `aria-live` to "off" prevents
      // double announcements from VO when `focusRegionOnTextChange` is true
      ,
      "aria-hidden": toggle ? undefined : 'true',
      "aria-live": !toggle || focusRegionOnTextChange ? 'off' : ariaLive
    }, isActive && toggle ? children : ''), (0, _react2.jsx)("div", {
      role: role,
      "aria-atomic": "true",
      "aria-hidden": !toggle ? undefined : 'true',
      "aria-live": toggle || focusRegionOnTextChange ? 'off' : ariaLive
    }, isActive && !toggle ? children : '')))
  );
};
EuiScreenReaderLive.propTypes = {
  /**
     * Whether to make screen readers aware of the content
     */
  isActive: _propTypes.default.bool,
  /**
     * Content for screen readers to announce
     */
  children: _propTypes.default.node,
  /**
     * `role` attribute for both live regions.
     *
     * https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Live_Regions#roles_with_implicit_live_region_attributes
     */
  role: _propTypes.default.any,
  /**
     * `aria-live` attribute for both live regions
     */
  "aria-live": _propTypes.default.any,
  /**
     * On `children`/text change, the region will auto-focus itself, causing screen readers
     * to automatically read out the text content. This prop should primarily be used for
     * navigation or page changes, where programmatically resetting focus location back to
     * a certain part of the page is desired.
     */
  focusRegionOnTextChange: _propTypes.default.bool
};