"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PADDING_SIZES = exports.EuiAccordionClass = exports.EuiAccordion = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _loading = require("../loading");
var _accordion_trigger = require("./accordion_trigger");
var _accordion_children = require("./accordion_children");
var _accordion = require("./accordion.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "id", "role", "element", "buttonElement", "buttonProps", "buttonClassName", "buttonContentClassName", "buttonContent", "arrowDisplay", "arrowProps", "extraAction", "paddingSize", "borders", "initialIsOpen", "forceState", "isLoading", "isLoadingMessage", "isDisabled", "theme"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var PADDING_SIZES = exports.PADDING_SIZES = ['none', 'xs', 's', 'm', 'l', 'xl'];
var EuiAccordionClass = exports.EuiAccordionClass = /*#__PURE__*/function (_Component) {
  function EuiAccordionClass() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiAccordionClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiAccordionClass, [].concat(args));
    (0, _defineProperty2.default)(_this, "state", {
      isOpen: _this.props.forceState ? _this.props.forceState === 'open' : _this.props.initialIsOpen
    });
    (0, _defineProperty2.default)(_this, "onToggle", function () {
      var forceState = _this.props.forceState;
      if (forceState) {
        var _this$props$onToggle, _this$props;
        var nextState = !_this.isOpen;
        (_this$props$onToggle = (_this$props = _this.props).onToggle) === null || _this$props$onToggle === void 0 || _this$props$onToggle.call(_this$props, nextState);
      } else {
        _this.setState(function (prevState) {
          return {
            isOpen: !prevState.isOpen
          };
        }, function () {
          var _this$props$onToggle2, _this$props2;
          (_this$props$onToggle2 = (_this$props2 = _this.props).onToggle) === null || _this$props$onToggle2 === void 0 || _this$props$onToggle2.call(_this$props2, _this.state.isOpen);
        });
      }
    });
    (0, _defineProperty2.default)(_this, "generatedId", (0, _services.htmlIdGenerator)()());
    return _this;
  }
  (0, _inherits2.default)(EuiAccordionClass, _Component);
  return (0, _createClass2.default)(EuiAccordionClass, [{
    key: "isOpen",
    get: function get() {
      return this.props.forceState ? this.props.forceState === 'open' : this.state.isOpen;
    }
  }, {
    key: "render",
    value: function render() {
      var _buttonProps$id;
      var _this$props3 = this.props,
        children = _this$props3.children,
        className = _this$props3.className,
        id = _this$props3.id,
        role = _this$props3.role,
        _this$props3$element = _this$props3.element,
        Element = _this$props3$element === void 0 ? 'div' : _this$props3$element,
        buttonElement = _this$props3.buttonElement,
        buttonProps = _this$props3.buttonProps,
        buttonClassName = _this$props3.buttonClassName,
        buttonContentClassName = _this$props3.buttonContentClassName,
        buttonContent = _this$props3.buttonContent,
        arrowDisplay = _this$props3.arrowDisplay,
        arrowProps = _this$props3.arrowProps,
        extraAction = _this$props3.extraAction,
        paddingSize = _this$props3.paddingSize,
        borders = _this$props3.borders,
        initialIsOpen = _this$props3.initialIsOpen,
        forceState = _this$props3.forceState,
        isLoading = _this$props3.isLoading,
        isLoadingMessage = _this$props3.isLoadingMessage,
        isDisabled = _this$props3.isDisabled,
        theme = _this$props3.theme,
        rest = (0, _objectWithoutProperties2.default)(_this$props3, _excluded);
      var classes = (0, _classnames.default)('euiAccordion', {
        'euiAccordion-isOpen': this.isOpen
      }, className);
      var styles = (0, _accordion.euiAccordionStyles)(theme);
      var cssStyles = [styles.euiAccordion, borders !== 'none' && styles.borders.borders, borders !== 'none' && styles.borders[borders]];
      var buttonId = (_buttonProps$id = buttonProps === null || buttonProps === void 0 ? void 0 : buttonProps.id) !== null && _buttonProps$id !== void 0 ? _buttonProps$id : this.generatedId;
      return (0, _react2.jsx)(Element, (0, _extends2.default)({
        className: classes,
        css: cssStyles
      }, rest), (0, _react2.jsx)(_accordion_trigger.EuiAccordionTrigger, {
        ariaControlsId: id,
        buttonId: buttonId
        // Force button element to be a legend if the element is a fieldset
        ,
        buttonElement: Element === 'fieldset' ? 'legend' : buttonElement,
        buttonClassName: buttonClassName,
        buttonContent: buttonContent,
        buttonContentClassName: buttonContentClassName,
        buttonProps: buttonProps,
        arrowProps: arrowProps,
        arrowDisplay: arrowDisplay,
        isDisabled: isDisabled,
        isOpen: this.isOpen,
        onToggle: this.onToggle,
        extraAction: isLoading ? (0, _react2.jsx)(_loading.EuiLoadingSpinner, null) : extraAction
      }), (0, _react2.jsx)(_accordion_children.EuiAccordionChildren, {
        role: role,
        id: id,
        "aria-labelledby": buttonId,
        paddingSize: paddingSize,
        isLoading: isLoading,
        isLoadingMessage: isLoadingMessage,
        isOpen: this.isOpen
      }, children));
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiAccordionClass, "defaultProps", {
  initialIsOpen: false,
  borders: 'none',
  paddingSize: 'none',
  arrowDisplay: 'left',
  isLoading: false,
  isDisabled: false,
  isLoadingMessage: false,
  element: 'div',
  buttonElement: 'button',
  role: 'group'
});
EuiAccordionClass.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  id: _propTypes.default.string.isRequired,
  /**
       * Applied to the entire .euiAccordion wrapper.
       * When using `fieldset`, it will enforce `buttonElement = legend` as well.
       */
  element: _propTypes.default.oneOf(["div", "fieldset"]),
  /**
       * Defaults to the [group role](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/group_role).
       *
       * If your accordion contains significant enough content to be a document
       * [landmark role](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/region_role#accessibility_concerns), consider using the `region` role instead.
       * @default group
       */
  role: _propTypes.default.any,
  /**
       * Class that will apply to the trigger for the accordion.
       */
  buttonClassName: _propTypes.default.string,
  /**
       * Apply more props to the triggering button.
       *
       * Includes optional `paddingSize` prop which allows sizes of `s`, `m`, or `l`.
       * Note: Padding will not be present on the side closest to the accordion arrow.
       */
  buttonProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    paddingSize: _propTypes.default.oneOf(["s", "m", "l"])
  }),
  /**
       * Class that will apply to the trigger content for the accordion.
       */
  buttonContentClassName: _propTypes.default.string,
  /**
       * The content of the clickable trigger
       */
  buttonContent: _propTypes.default.node,
  /**
       * Applied to the main button receiving the `onToggle` event.
       * Anything other than the default `button` does not support removing the arrow display (for accessibility of focus).
       */
  buttonElement: _propTypes.default.oneOf(["div", "legend", "button"]),
  /**
       * Extra props to pass to the EuiButtonIcon containing the arrow.
       */
  arrowProps: _propTypes.default.any,
  /**
       * Will appear right aligned against the button. Useful for separate actions like deletions.
       */
  extraAction: _propTypes.default.node,
  /**
       * The accordion will start in the open state.
       */
  initialIsOpen: _propTypes.default.bool,
  /**
       * Optional callback method called on open and close with a single `isOpen` parameter
       */
  onToggle: _propTypes.default.func,
  /**
       * The padding around the exposed accordion content.
       */
  paddingSize: _propTypes.default.any,
  /**
       * Placement of the arrow indicator, or 'none' to hide it.
       */
  arrowDisplay: _propTypes.default.oneOf(["left", "right", "none"]),
  /**
       * Optional border styling. Defaults to 'none'.
       */
  borders: _propTypes.default.oneOf(["horizontal", "all", "none"]),
  /**
       * Control the opening of accordion via prop
       */
  forceState: _propTypes.default.oneOf(["closed", "open"]),
  /**
       * Change `extraAction` and children into a loading spinner
       */
  isLoading: _propTypes.default.bool,
  /**
       * Choose whether the loading message replaces the content. Customize the message by passing a node
       */
  isLoadingMessage: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.node.isRequired]),
  /**
       * Disable the open/close interaction and visually subdues the trigger
       */
  isDisabled: _propTypes.default.bool
};
var EuiAccordion = exports.EuiAccordion = (0, _services.withEuiTheme)(EuiAccordionClass);