"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAccordionChildren = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _resize_observer = require("../../observer/resize_observer");
var _accordion_children_loading = require("./accordion_children_loading");
var _accordion_children = require("./accordion_children.styles");
var _react2 = require("@emotion/react");
var _excluded = ["role", "children", "paddingSize", "isLoading", "isLoadingMessage", "isOpen"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiAccordionChildren = exports.EuiAccordionChildren = function EuiAccordionChildren(_ref) {
  var role = _ref.role,
    children = _ref.children,
    paddingSize = _ref.paddingSize,
    isLoading = _ref.isLoading,
    isLoadingMessage = _ref.isLoadingMessage,
    isOpen = _ref.isOpen,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  /**
   * Children
   */
  var classes = (0, _classnames.default)('euiAccordion__children', {
    'euiAccordion__children-isLoading': isLoading
  });
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _accordion_children.euiAccordionChildrenStyles)(euiTheme);
  var cssStyles = [styles.euiAccordion__children, isLoading && styles.isLoading, paddingSize && paddingSize !== 'none' && styles[paddingSize]];

  /**
   * Wrapper
   */
  var wrapperStyles = (0, _accordion_children.euiAccordionChildWrapperStyles)(euiTheme);
  var wrapperCssStyles = [wrapperStyles.euiAccordion__childWrapper, isOpen ? wrapperStyles.isOpen : wrapperStyles.isClosed];

  /**
   * Update the accordion wrapper height whenever the accordion opens, and also
   * whenever the child content updates (which will change the height)
   */
  var _useState = (0, _react.useState)(0),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    contentHeight = _useState2[0],
    setContentHeight = _useState2[1];
  var onResize = (0, _react.useCallback)(function (_ref2) {
    var height = _ref2.height;
    return setContentHeight(Math.round(height));
  }, []);
  var heightInlineStyle = (0, _react.useMemo)(function () {
    return {
      blockSize: isOpen ? contentHeight : 0
    };
  }, [isOpen, contentHeight]);
  return (0, _react2.jsx)("div", (0, _extends2.default)({}, rest, {
    className: "euiAccordion__childWrapper",
    css: wrapperCssStyles,
    style: heightInlineStyle,
    role: role
    // @ts-expect-error - inert property not yet available in React TS defs. TODO: Remove this once https://github.com/DefinitelyTyped/DefinitelyTyped/pull/60822 is merged
    ,
    inert: !isOpen ? '' : undefined // Can't pass a boolean currently, Jest throws errors
  }), (0, _react2.jsx)(_resize_observer.EuiResizeObserver, {
    onResize: onResize
  }, function (resizeRef) {
    return (0, _react2.jsx)("div", {
      ref: resizeRef,
      className: classes,
      css: cssStyles
    }, isLoading && isLoadingMessage ? (0, _react2.jsx)(_accordion_children_loading.EuiAccordionChildrenLoading, {
      isLoadingMessage: isLoadingMessage
    }) : children);
  }));
};
EuiAccordionChildren.propTypes = {
  isOpen: _propTypes.default.bool.isRequired
};