"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAccordionChildrenLoading = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _text = require("../../text");
var _loading = require("../../loading");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiAccordionChildrenLoading = exports.EuiAccordionChildrenLoading = function EuiAccordionChildrenLoading(_ref) {
  var isLoadingMessage = _ref.isLoadingMessage;
  var _useEuiTheme = (0, _services.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme;
  return (0, _react.jsx)(_react2.default.Fragment, null, (0, _react.jsx)(_loading.EuiLoadingSpinner, {
    className: "euiAccordion__spinner",
    css: /*#__PURE__*/(0, _react.css)({
      marginInlineEnd: euiTheme.size.xs
    }, ";label:EuiAccordionChildrenLoading;")
  }), (0, _react.jsx)(_text.EuiText, {
    size: "s"
  }, (0, _react.jsx)("p", null, isLoadingMessage !== true ? isLoadingMessage : (0, _react.jsx)(_i18n.EuiI18n, {
    token: "euiAccordionChildrenLoading.message",
    default: "Loading"
  }))));
};