"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAccordionTrigger = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _accordion_button = require("./accordion_button");
var _accordion_arrow = require("./accordion_arrow");
var _react2 = require("@emotion/react");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "7vgam2-euiAccordion-optionalAction",
  styles: "flex-shrink:0;label:euiAccordion;label:optionalAction;"
} : {
  name: "7vgam2-euiAccordion-optionalAction",
  styles: "flex-shrink:0;label:euiAccordion;label:optionalAction;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "osepuu-EuiAccordionTrigger",
  styles: "display:flex;align-items:center;label:EuiAccordionTrigger;"
} : {
  name: "osepuu-EuiAccordionTrigger",
  styles: "display:flex;align-items:center;label:EuiAccordionTrigger;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var EuiAccordionTrigger = exports.EuiAccordionTrigger = function EuiAccordionTrigger(_ref) {
  var _arrowDisplay = _ref.arrowDisplay,
    arrowProps = _ref.arrowProps,
    _ref$buttonElement = _ref.buttonElement,
    buttonElement = _ref$buttonElement === void 0 ? 'button' : _ref$buttonElement,
    buttonProps = _ref.buttonProps,
    buttonClassName = _ref.buttonClassName,
    buttonContent = _ref.buttonContent,
    buttonContentClassName = _ref.buttonContentClassName,
    buttonId = _ref.buttonId,
    ariaControlsId = _ref.ariaControlsId,
    isDisabled = _ref.isDisabled,
    isOpen = _ref.isOpen,
    onToggle = _ref.onToggle,
    extraAction = _ref.extraAction;
  // Force visibility of arrow button icon if button element is not interactive
  var buttonIsInteractive = buttonElement === 'button';
  var arrowDisplay = _arrowDisplay === 'none' && !buttonIsInteractive ? 'left' : _arrowDisplay;
  var arrow = (0, _react2.jsx)(_accordion_arrow.EuiAccordionArrow, {
    arrowDisplay: arrowDisplay,
    arrowProps: arrowProps,
    isOpen: isOpen,
    onClick: onToggle,
    isDisabled: isDisabled,
    "aria-controls": ariaControlsId,
    "aria-expanded": isOpen,
    "aria-labelledby": buttonId,
    tabIndex: buttonIsInteractive ? -1 : 0
  });
  var button = (0, _react2.jsx)(_accordion_button.EuiAccordionButton, {
    buttonElement: buttonElement,
    buttonProps: buttonProps,
    buttonClassName: buttonClassName,
    buttonContentClassName: buttonContentClassName,
    arrowDisplay: arrowDisplay,
    isDisabled: isDisabled,
    id: buttonId,
    "aria-controls": ariaControlsId,
    "aria-expanded": buttonIsInteractive ? isOpen : undefined // `aria-expanded` is only a valid attribute on interactive controls - axe-core throws a violation otherwise
    ,
    onClick: isDisabled ? undefined : onToggle
  }, buttonContent);
  var optionalAction = extraAction && (0, _react2.jsx)("div", {
    className: "euiAccordion__optionalAction",
    css: _ref2
  }, extraAction);
  return (0, _react2.jsx)("div", {
    className: "euiAccordion__triggerWrapper",
    css: _ref3
  }, arrowDisplay === 'left' && arrow, button, optionalAction, arrowDisplay === 'right' && arrow);
};
EuiAccordionTrigger.propTypes = {
  isOpen: _propTypes.default.bool.isRequired,
  ariaControlsId: _propTypes.default.string.isRequired,
  buttonId: _propTypes.default.string.isRequired,
  onToggle: _propTypes.default.func.isRequired
};