"use strict";

var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaginationBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _spacer = require("../spacer");
var _table_pagination = require("../table/table_pagination");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var PaginationBar = exports.PaginationBar = function PaginationBar(_ref) {
  var pagination = _ref.pagination,
    onPageSizeChange = _ref.onPageSizeChange,
    onPageChange = _ref.onPageChange,
    ariaControls = _ref['aria-controls'],
    ariaLabel = _ref['aria-label'];
  var defaults = (0, _table_pagination.useEuiTablePaginationDefaults)();
  var pageIndex = pagination.pageIndex,
    totalItemCount = pagination.totalItemCount,
    _pagination$pageSize = pagination.pageSize,
    pageSize = _pagination$pageSize === void 0 ? defaults.itemsPerPage : _pagination$pageSize,
    _pagination$pageSizeO = pagination.pageSizeOptions,
    pageSizeOptions = _pagination$pageSizeO === void 0 ? defaults.itemsPerPageOptions : _pagination$pageSizeO,
    _pagination$showPerPa = pagination.showPerPageOptions,
    showPerPageOptions = _pagination$showPerPa === void 0 ? defaults.showPerPageOptions : _pagination$showPerPa;
  var pageCount = pageSize ? Math.ceil(totalItemCount / pageSize) : 1;
  (0, _react.useEffect)(function () {
    if (pageCount < pageIndex + 1) {
      onPageChange === null || onPageChange === void 0 || onPageChange(pageCount - 1);
    }
  }, [pageCount, onPageChange, pageIndex]);
  return (0, _react2.jsx)("div", null, (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m"
  }), (0, _react2.jsx)(_table_pagination.EuiTablePagination, {
    activePage: pageIndex,
    showPerPageOptions: showPerPageOptions,
    itemsPerPage: pageSize,
    itemsPerPageOptions: pageSizeOptions,
    pageCount: pageCount,
    onChangeItemsPerPage: onPageSizeChange,
    onChangePage: onPageChange,
    "aria-controls": ariaControls,
    "aria-label": ariaLabel
  }));
};