"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POSITIONS = exports.PADDING_SIZES = exports.EuiBottomBar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _accessibility = require("../accessibility");
var _i18n = require("../i18n");
var _resize_observer = require("../observer/resize_observer");
var _portal = require("../portal");
var _bottom_bar = require("./bottom_bar.styles");
var _react2 = require("@emotion/react");
var _excluded = ["position", "paddingSize", "affordForDisplacement", "children", "className", "bodyClassName", "landmarkHeading", "usePortal", "left", "right", "bottom", "top", "style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var PADDING_SIZES = exports.PADDING_SIZES = ['none', 's', 'm', 'l'];
var POSITIONS = exports.POSITIONS = ['static', 'fixed', 'sticky'];
var _EuiBottomBar = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'fixed' : _ref$position,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
    _ref$affordForDisplac = _ref.affordForDisplacement,
    affordForDisplacement = _ref$affordForDisplac === void 0 ? true : _ref$affordForDisplac,
    children = _ref.children,
    className = _ref.className,
    bodyClassName = _ref.bodyClassName,
    landmarkHeading = _ref.landmarkHeading,
    _ref$usePortal = _ref.usePortal,
    usePortal = _ref$usePortal === void 0 ? true : _ref$usePortal,
    _ref$left = _ref.left,
    left = _ref$left === void 0 ? 0 : _ref$left,
    _ref$right = _ref.right,
    right = _ref$right === void 0 ? 0 : _ref$right,
    _ref$bottom = _ref.bottom,
    bottom = _ref$bottom === void 0 ? 0 : _ref$bottom,
    top = _ref.top,
    style = _ref.style,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_bottom_bar.euiBottomBarStyles);

  // Force some props if `fixed` position, but not if the user has supplied these
  affordForDisplacement = position !== 'fixed' ? false : affordForDisplacement;
  usePortal = position !== 'fixed' ? false : usePortal;
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    resizeRef = _useState2[0],
    setResizeRef = _useState2[1];
  var setRef = (0, _services.useCombinedRefs)([setResizeRef, ref]);
  // TODO: Allow this hooke to be conditional
  var dimensions = (0, _resize_observer.useResizeObserver)(resizeRef);
  (0, _react.useEffect)(function () {
    if (affordForDisplacement && usePortal) {
      document.body.style.paddingBottom = "".concat(dimensions.height, "px");
    }
    if (bodyClassName) {
      document.body.classList.add(bodyClassName);
    }
    return function () {
      if (affordForDisplacement && usePortal) {
        document.body.style.paddingBottom = '';
      }
      if (bodyClassName) {
        document.body.classList.remove(bodyClassName);
      }
    };
  }, [affordForDisplacement, usePortal, dimensions, bodyClassName]);
  var classes = (0, _classnames.default)('euiBottomBar', "euiBottomBar--".concat(position), className);
  var cssStyles = [styles.euiBottomBar, styles[position], styles[paddingSize]];
  var newStyle = _objectSpread({
    left: left,
    right: right,
    bottom: bottom,
    top: top
  }, style);
  var bar = (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiBottomBar.screenReaderHeading",
    default: "Page level controls"
  }, function (screenReaderHeading) {
    return (
      // Though it would be better to use aria-labelledby than aria-label and not repeat the same string twice
      // A bug in voiceover won't list some landmarks in the rotor without an aria-label

      (0, _react2.jsx)("section", (0, _extends2.default)({
        "aria-label": landmarkHeading ? landmarkHeading : screenReaderHeading,
        className: classes,
        css: cssStyles,
        ref: setRef,
        style: newStyle
      }, rest), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("h2", null, landmarkHeading ? landmarkHeading : screenReaderHeading)), children)
    );
  }), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
    "aria-live": "assertive"
  }, landmarkHeading ? (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiBottomBar.customScreenReaderAnnouncement",
    default: "There is a new region landmark called {landmarkHeading} with page level controls at the end of the document.",
    values: {
      landmarkHeading: landmarkHeading
    }
  }) : (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiBottomBar.screenReaderAnnouncement",
    default: "There is a new region landmark with page level controls at the end of the document."
  }))));
  return usePortal ? (0, _react2.jsx)(_portal.EuiPortal, typeof usePortal !== 'boolean' ? usePortal : undefined, bar) : bar;
});
_EuiBottomBar.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * How to position the bottom bar against its parent.
       */
  position: _propTypes.default.oneOfType([_propTypes.default.oneOf(["fixed"]), _propTypes.default.oneOf(["static", "sticky"]).isRequired]),
  /**
       * Whether to wrap in an EuiPortal which appends the component to the body element.
       * Only works if `position` is `fixed`.
       */
  usePortal: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    /**
       * ReactNode to render as this component's content
       */
    children: _propTypes.default.node.isRequired,
    /**
       * If not specified, `EuiPortal` will insert itself
       * into the end of the `document.body` by default
       */
    insert: _propTypes.default.shape({
      sibling: _propTypes.default.any.isRequired,
      position: _propTypes.default.any.isRequired
    }),
    /**
       * Optional ref callback
       */
    portalRef: _propTypes.default.func
  }).isRequired]),
  /**
       * Whether the component should apply padding on the document body element to afford for its own displacement height.
       * Only works if `usePortal` is true and `position` is `fixed`.
       */
  affordForDisplacement: _propTypes.default.bool,
  /**
       * Padding applied to the bar. Default is 'm'.
       */
  paddingSize: _propTypes.default.any,
  /**
       * Optional class applied to the body element on mount.
       */
  bodyClassName: _propTypes.default.string,
  /**
       * Customize the screen reader heading that helps users find this control.
       *
       * @default Page level controls
       */
  landmarkHeading: _propTypes.default.string,
  /**
       * Starting vertical position when `fixed` position.
       * Offset from the top of the window when `sticky` position.
       * Has no affect on `static` positions.
       */
  top: _propTypes.default.any,
  /**
       * Ending horizontal position when `fixed` position.
       * Has no affect on `static` or `sticky` positions.
       */
  right: _propTypes.default.any,
  /**
       * Starting vertical position when `fixed` position.
       * Offset from the bottom of the window when `sticky` position.
       * Has no affect on `static` positions.
       */
  bottom: _propTypes.default.any,
  /**
       * Starting horizontal position when `fixed` position.
       * Has no affect on `static` or `sticky` positions.
       */
  left: _propTypes.default.any
};
var EuiBottomBar = exports.EuiBottomBar = /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
  var BottomBar = _EuiBottomBar;
  return (0, _react2.jsx)(_services.EuiThemeProvider, {
    colorMode: "dark",
    wrapperProps: {
      cloneElement: true
    }
  }, (0, _react2.jsx)(BottomBar, (0, _extends2.default)({
    ref: ref
  }, props)));
});
EuiBottomBar.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * How to position the bottom bar against its parent.
       */
  position: _propTypes.default.oneOfType([_propTypes.default.oneOf(["fixed"]), _propTypes.default.oneOf(["static", "sticky"]).isRequired]),
  /**
       * Whether to wrap in an EuiPortal which appends the component to the body element.
       * Only works if `position` is `fixed`.
       */
  usePortal: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    children: _propTypes.default.node.isRequired,
    insert: _propTypes.default.shape({
      sibling: _propTypes.default.any.isRequired,
      position: _propTypes.default.any.isRequired
    }),
    portalRef: _propTypes.default.func
  }).isRequired]),
  /**
       * Whether the component should apply padding on the document body element to afford for its own displacement height.
       * Only works if `usePortal` is true and `position` is `fixed`.
       */
  affordForDisplacement: _propTypes.default.bool,
  /**
       * Padding applied to the bar. Default is 'm'.
       */
  paddingSize: _propTypes.default.any,
  /**
       * Optional class applied to the body element on mount.
       */
  bodyClassName: _propTypes.default.string,
  /**
       * Customize the screen reader heading that helps users find this control.
       *
       * @default Page level controls
       */
  landmarkHeading: _propTypes.default.string,
  /**
       * Starting vertical position when `fixed` position.
       * Offset from the top of the window when `sticky` position.
       * Has no affect on `static` positions.
       */
  top: _propTypes.default.any,
  /**
       * Ending horizontal position when `fixed` position.
       * Has no affect on `static` or `sticky` positions.
       */
  right: _propTypes.default.any,
  /**
       * Starting vertical position when `fixed` position.
       * Offset from the bottom of the window when `sticky` position.
       * Has no affect on `static` positions.
       */
  bottom: _propTypes.default.any,
  /**
       * Starting horizontal position when `fixed` position.
       * Has no affect on `static` or `sticky` positions.
       */
  left: _propTypes.default.any
};
EuiBottomBar.displayName = 'EuiBottomBar';
_EuiBottomBar.displayName = 'EuiBottomBar';