"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBreadcrumbCollapsed = exports.EuiBreadcrumb = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _breadcrumb_content = require("./_breadcrumb_content");
var _breadcrumb = require("./breadcrumb.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "type", "truncate"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiBreadcrumb = exports.EuiBreadcrumb = function EuiBreadcrumb(_ref) {
  var children = _ref.children,
    className = _ref.className,
    type = _ref.type,
    truncate = _ref.truncate,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiBreadcrumb', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_breadcrumb.euiBreadcrumbStyles);
  var cssStyles = [styles.euiBreadcrumb, styles[type], truncate && styles.isTruncated];
  return (0, _react2.jsx)("li", (0, _extends2.default)({
    className: classes,
    css: cssStyles,
    "data-test-subj": "euiBreadcrumb"
  }, rest), children);
};
var EuiBreadcrumbCollapsed = exports.EuiBreadcrumbCollapsed = function EuiBreadcrumbCollapsed(_ref2) {
  var children = _ref2.children,
    isFirstBreadcrumb = _ref2.isFirstBreadcrumb,
    type = _ref2.type;
  var styles = (0, _services.useEuiMemoizedStyles)(_breadcrumb.euiBreadcrumbStyles);
  var cssStyles = [styles.isCollapsed];
  var ariaLabel = (0, _i18n.useEuiI18n)('euiBreadcrumb.collapsedBadge.ariaLabel', 'See collapsed breadcrumbs');
  return (0, _react2.jsx)(EuiBreadcrumb, {
    css: cssStyles,
    type: type
  }, (0, _react2.jsx)(_breadcrumb_content.EuiBreadcrumbContent, {
    popoverContent: children,
    text: (0, _react2.jsx)("span", {
      "aria-label": ariaLabel
    }, "\u2026"),
    title: ariaLabel,
    truncate: false,
    isFirstBreadcrumb: isFirstBreadcrumb,
    type: type
  }));
};