"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCodeBlockStyles = exports.euiCodeBlockPreStyles = exports.euiCodeBlockCodeStyles = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _code_syntax = require("./code_syntax.styles");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "i92zwx-isFullScreen",
  styles: "position:fixed;inset:0;label:isFullScreen;"
} : {
  name: "i92zwx-isFullScreen",
  styles: "position:fixed;inset:0;label:isFullScreen;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref5 = process.env.NODE_ENV === "production" ? {
  name: "gfiv3z-transparentBackground",
  styles: "background:transparent;label:transparentBackground;"
} : {
  name: "gfiv3z-transparentBackground",
  styles: "background:transparent;label:transparentBackground;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCodeBlockStyles = exports.euiCodeBlockStyles = function euiCodeBlockStyles(euiThemeContext) {
  var codeSyntaxVariables = (0, _code_syntax.euiCodeSyntaxVariables)(euiThemeContext);
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiCodeBlock: /*#__PURE__*/(0, _react.css)("max-inline-size:100%;display:block;position:relative;background:", codeSyntaxVariables.backgroundColor, ";", codeSyntaxVariables.tokensCss, ";;label:euiCodeBlock;"),
    // Font size
    s: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'm'), ";;label:l;"),
    // Variants
    transparentBackground: _ref5,
    isFullScreen: _ref4,
    // Account for control heights
    hasControls: generatePaddingCss(euiThemeContext, function (paddingSize) {
      return /*#__PURE__*/(0, _react.css)("min-block-size:", (0, _global_styling.mathWithUnits)([euiTheme.size.l, paddingSize], function (iconSize, paddingSize) {
        return iconSize + paddingSize * 2;
      }), ";;label:hasControls;");
    }),
    hasBothControls: generatePaddingCss(euiThemeContext, function (paddingSize) {
      return /*#__PURE__*/(0, _react.css)("min-block-size:", (0, _global_styling.mathWithUnits)([euiTheme.size.l, euiTheme.size.xs, paddingSize], function (iconSize, gap, paddingSize) {
        return iconSize * 2 + gap + paddingSize * 2;
      }), ";;label:hasBothControls;");
    })
  };
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "eav5br-preWrap",
  styles: "white-space:pre-wrap;label:preWrap;"
} : {
  name: "eav5br-preWrap",
  styles: "white-space:pre-wrap;label:preWrap;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "4dmmkq-pre",
  styles: "white-space:pre;label:pre;"
} : {
  name: "4dmmkq-pre",
  styles: "white-space:pre;label:pre;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCodeBlockPreStyles = exports.euiCodeBlockPreStyles = function euiCodeBlockPreStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiCodeBlock__pre: /*#__PURE__*/(0, _react.css)("block-size:100%;overflow:auto;display:block;", (0, _global_styling.euiScrollBarStyles)(euiThemeContext), ";;label:euiCodeBlock__pre;"),
    padding: _objectSpread({}, generatePaddingCss(euiThemeContext, function (paddingSize) {
      return /*#__PURE__*/(0, _react.css)("padding:", paddingSize, ";;label:padding;");
    })),
    whiteSpace: {
      pre: {
        pre: _ref3,
        controlsOffset: generatePaddingCss(euiThemeContext, function (paddingSize) {
          return /*#__PURE__*/(0, _react.css)("margin-inline-end:", (0, _global_styling.mathWithUnits)([paddingSize, euiTheme.size.l, euiTheme.size.xs], function (paddingSize, iconSize, gap) {
            return paddingSize + gap + iconSize;
          }), ";;label:controlsOffset;");
        })
      },
      preWrap: {
        preWrap: _ref2,
        controlsOffset: generatePaddingCss(euiThemeContext, function (paddingSize) {
          return /*#__PURE__*/(0, _react.css)("padding-inline-end:", (0, _global_styling.mathWithUnits)([paddingSize, euiTheme.size.l, euiTheme.size.xs], function (paddingSize, iconSize, gap) {
            return paddingSize + gap + iconSize;
          }), ";;label:controlsOffset;");
        })
      }
    }
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "9y8iu3-isVirtualized",
  styles: "position:relative;label:isVirtualized;"
} : {
  name: "9y8iu3-isVirtualized",
  styles: "position:relative;label:isVirtualized;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiCodeBlockCodeStyles = exports.euiCodeBlockCodeStyles = function euiCodeBlockCodeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiCodeBlock__code: /*#__PURE__*/(0, _react.css)("font-family:", euiTheme.font.familyCode, ";font-size:inherit;color:", euiTheme.colors.text, ";display:block;;label:euiCodeBlock__code;"),
    isVirtualized: _ref
  };
};

/**
 * Helper for generating keys for each code block padding size
 */
var generatePaddingCss = function generatePaddingCss(euiThemeContext, callback) {
  var cssKeys = {
    none: /*#__PURE__*/(0, _react.css)(";label:none;"),
    s: /*#__PURE__*/(0, _react.css)(";label:s;"),
    m: /*#__PURE__*/(0, _react.css)(";label:m;"),
    l: /*#__PURE__*/(0, _react.css)(";label:l;"),
    xl: /*#__PURE__*/(0, _react.css)(";label:xl;")
  }; // xl padding used by fullscreen mode

  ['none', 's', 'm', 'l', 'xl'].forEach(function (size) {
    var paddingSize = (0, _global_styling.euiPaddingSize)(euiThemeContext, size) || 0;
    cssKeys[size] = callback(paddingSize);
  });
  return cssKeys;
};