"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCopy = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _copy = require("../copy");
var _i18n = require("../i18n");
var _button = require("../button");
var _utils = require("./utils");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Hook that returns copy-related state/logic/utils
 */
var useCopy = exports.useCopy = function useCopy(_ref) {
  var copyAriaLabel = _ref.copyAriaLabel,
    isCopyable = _ref.isCopyable,
    isVirtualized = _ref.isVirtualized,
    children = _ref.children;
  var _useInnerText = (0, _inner_text.useInnerText)(''),
    _useInnerText2 = (0, _slicedToArray2.default)(_useInnerText, 2),
    innerTextRef = _useInnerText2[0],
    _innerText = _useInnerText2[1];
  var innerText = (0, _react.useMemo)(function () {
    var _innerText$replace;
    if (!_innerText) return;
    return (_innerText
    // remove text that should not be copied (e.g. screen reader instructions)
    === null || _innerText
    // remove text that should not be copied (e.g. screen reader instructions)
    === void 0 || (_innerText$replace = _innerText
    // remove text that should not be copied (e.g. screen reader instructions)
    .replace(_services.noCopyBoundsRegex, '')
    // Normalize line terminations to match native JS format
    ) === null || _innerText$replace === void 0 || (_innerText$replace = _innerText$replace.replace(_utils.NEW_LINE_REGEX_GLOBAL, '\n')
    // remove initial line break (if there was hidden content removed)
    ) === null || _innerText$replace === void 0 || (_innerText$replace = _innerText$replace.replace(/^\n/, '')
    // Reduce two or more consecutive new line characters to a single one
    // This is needed primarily because of how syntax highlighting
    // generated DOM elements affect `innerText` output.
    ) === null || _innerText$replace === void 0 ? void 0 : _innerText$replace.replace(/\n{2,}/g, '\n')) || '';
  }, [_innerText]);
  var textToCopy = isVirtualized ? "".concat(children) : innerText; // Virtualized code blocks do not have inner text

  var showCopyButton = isCopyable && textToCopy;
  var copyDefaultAriaLabel = (0, _i18n.useEuiI18n)('euiCodeBlockCopy.copy', 'Copy');
  var copyButton = (0, _react.useMemo)(function () {
    return showCopyButton ? (0, _react2.jsx)("div", {
      className: "euiCodeBlock__copyButton"
    }, (0, _react2.jsx)(_copy.EuiCopy, {
      textToCopy: textToCopy
    }, function (copy) {
      return (0, _react2.jsx)(_button.EuiButtonIcon, {
        onClick: copy,
        iconType: "copyClipboard",
        color: "text",
        "aria-label": copyAriaLabel || copyDefaultAriaLabel,
        "data-test-subj": "euiCodeBlockCopy"
      });
    })) : null;
  }, [copyAriaLabel, copyDefaultAriaLabel, showCopyButton, textToCopy]);
  return {
    innerTextRef: innerTextRef,
    copyButton: copyButton
  };
};