"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCodeBlockVirtualized = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _reactWindow = require("react-window");
var _global_styling = require("../../global_styling");
var _auto_sizer = require("../auto_sizer");
var _utils = require("./utils");
var _react2 = require("@emotion/react");
var _excluded = ["style"],
  _excluded2 = ["style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiCodeBlockVirtualized = exports.EuiCodeBlockVirtualized = function EuiCodeBlockVirtualized(_ref) {
  var data = _ref.data,
    rowHeight = _ref.rowHeight,
    overflowHeight = _ref.overflowHeight,
    preProps = _ref.preProps,
    codeProps = _ref.codeProps;
  var VirtualizedOuterElement = (0, _react.useMemo)(function () {
    return /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
      var style = _ref2.style,
        props = (0, _objectWithoutProperties2.default)(_ref2, _excluded);
      return (0, _react2.jsx)("pre", (0, _extends2.default)({
        style: (0, _global_styling.logicalStyles)(style)
      }, props, {
        ref: ref
      }, preProps));
    });
  }, [preProps]);
  var VirtualizedInnerElement = (0, _react.useMemo)(function () {
    return /*#__PURE__*/(0, _react.forwardRef)(function (_ref3, ref) {
      var style = _ref3.style,
        props = (0, _objectWithoutProperties2.default)(_ref3, _excluded2);
      return (0, _react2.jsx)("code", (0, _extends2.default)({
        style: (0, _global_styling.logicalStyles)(style)
      }, props, {
        ref: ref
      }, codeProps));
    });
  }, [codeProps]);
  var virtualizationProps = {
    itemData: data,
    itemSize: rowHeight,
    itemCount: data.length,
    outerElementType: VirtualizedOuterElement,
    innerElementType: VirtualizedInnerElement
  };
  return typeof overflowHeight === 'number' ? (0, _react2.jsx)(_auto_sizer.EuiAutoSizer, {
    disableHeight: true
  }, function (_ref4) {
    var width = _ref4.width;
    return (0, _react2.jsx)(_reactWindow.FixedSizeList, (0, _extends2.default)({
      height: overflowHeight,
      width: width
    }, virtualizationProps), ListRow);
  }) : (0, _react2.jsx)(_auto_sizer.EuiAutoSizer, null, function (_ref5) {
    var height = _ref5.height,
      width = _ref5.width;
    return (0, _react2.jsx)(_reactWindow.FixedSizeList, (0, _extends2.default)({
      height: height,
      width: width
    }, virtualizationProps), ListRow);
  });
};
var ListRow = function ListRow(_ref6) {
  var data = _ref6.data,
    index = _ref6.index,
    style = _ref6.style;
  var row = data[index];
  row.properties.style = (0, _global_styling.logicalStyles)(style);
  return (0, _utils.nodeToHtml)(row, index, data, 0);
};