"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavBeta = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flyout = require("../flyout");
var _i18n = require("../i18n");
var _header = require("../header/header.styles");
var _context = require("./context");
var _collapsible_nav_button = require("./collapsible_nav_button");
var _collapsible_nav_beta = require("./collapsible_nav_beta.styles");
var _collapsible_nav_body_footer = require("./collapsible_nav_body_footer");
var _collapsible_nav_item = require("./collapsible_nav_item");
var _kibana_solution = require("./_kibana_solution");
var _react2 = require("@emotion/react");
var _excluded = ["id", "children", "className", "initialIsCollapsed", "isCollapsed", "onCollapseToggle", "width", "side", "focusTrapProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var _EuiCollapsibleNavBeta = function _EuiCollapsibleNavBeta(_ref) {
  var id = _ref.id,
    children = _ref.children,
    className = _ref.className,
    _ref$initialIsCollaps = _ref.initialIsCollapsed,
    initialIsCollapsed = _ref$initialIsCollaps === void 0 ? false : _ref$initialIsCollaps,
    propsIsCollapsed = _ref.isCollapsed,
    onCollapseToggle = _ref.onCollapseToggle,
    _ref$width = _ref.width,
    _width = _ref$width === void 0 ? 248 : _ref$width,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'left' : _ref$side,
    _focusTrapProps = _ref.focusTrapProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useEuiThemeCSSVariab = (0, _services.useEuiThemeCSSVariables)(),
    setGlobalCSSVariables = _useEuiThemeCSSVariab.setGlobalCSSVariables;
  var _useEuiMemoizedStyles = (0, _services.useEuiMemoizedStyles)(_header.euiHeaderVariables),
    headerHeight = _useEuiMemoizedStyles.height;

  /**
   * Collapsed state
   */
  var _useState = (0, _react.useState)(initialIsCollapsed),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isCollapsed = _useState2[0],
    setIsCollapsed = _useState2[1];
  var toggleCollapsed = (0, _react.useCallback)(function () {
    return setIsCollapsed(function (isCollapsed) {
      onCollapseToggle === null || onCollapseToggle === void 0 || onCollapseToggle(!isCollapsed);
      return !isCollapsed;
    });
  }, [onCollapseToggle]);
  var onClose = (0, _react.useCallback)(function () {
    setIsCollapsed(true);
    onCollapseToggle === null || onCollapseToggle === void 0 || onCollapseToggle(true);
  }, [onCollapseToggle]);

  // Controlled state
  (0, _react.useEffect)(function () {
    if (propsIsCollapsed !== undefined) {
      setIsCollapsed(propsIsCollapsed);
    }
  }, [propsIsCollapsed]);

  /**
   * Responsive behavior
   * By default on large enough screens, the nav is always a push flyout,
   * but on smaller/mobile screens, the nav overlays the page instead
   */
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    isOverlay = _useState4[0],
    setIsOverlay = _useState4[1];
  var _useState5 = (0, _react.useState)(false),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    isOverlayFullWidth = _useState6[0],
    setIsOverlayFullWidth = _useState6[1];
  var _useState7 = (0, _react.useState)(false),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    isOverlayOpen = _useState8[0],
    setIsOverlayOpen = _useState8[1];
  var toggleOverlayFlyout = (0, _react.useCallback)(function () {
    setIsOverlayOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closeOverlayFlyout = (0, _react.useCallback)(function () {
    return setIsOverlayOpen(false);
  }, []);
  var flyoutType = isOverlay ? 'overlay' : 'push';
  var isPush = !isOverlay;

  // Set up a window resize listener that determines breakpoint behavior
  (0, _react.useEffect)(function () {
    var getBreakpoints = function getBreakpoints() {
      setIsOverlay(window.innerWidth < _width * 3);
      setIsOverlayFullWidth(window.innerWidth < _width * 1.5);
    };
    getBreakpoints();
    var onWindowResize = (0, _services.throttle)(getBreakpoints, 50);
    window.addEventListener('resize', onWindowResize);
    return function () {
      return window.removeEventListener('resize', onWindowResize);
    };
  }, [_width]);
  var width = (0, _react.useMemo)(function () {
    if (isOverlayFullWidth) return '100%';
    if (isPush && isCollapsed) return headerHeight;
    return "".concat(_width, "px");
  }, [_width, isOverlayFullWidth, isPush, isCollapsed, headerHeight]);

  // Other UI elements may need to account for the nav width -
  // set a global CSS variable that they can use
  (0, _react.useEffect)(function () {
    setGlobalCSSVariables({
      '--euiCollapsibleNavOffset': isOverlay ? '0' : width
    });
  }, [width, isOverlay, setGlobalCSSVariables]);

  /**
   * Prop setup
   */
  var flyoutID = (0, _services.useGeneratedHtmlId)({
    conditionalId: id,
    suffix: 'euiCollapsibleNav'
  });
  var defaultAriaLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavBeta.ariaLabel', 'Site menu');
  var buttonRef = (0, _react.useRef)(null);
  var focusTrapProps = (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, _focusTrapProps), {}, {
      shards: [buttonRef].concat((0, _toConsumableArray2.default)((_focusTrapProps === null || _focusTrapProps === void 0 ? void 0 : _focusTrapProps.shards) || []))
    });
  }, [_focusTrapProps]);
  var classes = (0, _classnames.default)('euiCollapsibleNav', 'euiCollapsibleNavBeta', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav_beta.euiCollapsibleNavBetaStyles);
  var cssStyles = [styles.euiCollapsibleNavBeta, styles[side], isPush && styles.isPush, isPush && isCollapsed && styles.isPushCollapsed, isOverlayFullWidth && styles.isOverlayFullWidth];
  var flyout = (0, _react2.jsx)(_flyout.EuiFlyout, (0, _extends2.default)({
    "aria-label": defaultAriaLabel
  }, rest, {
    // EuiCollapsibleNav is significantly less permissive than EuiFlyout
    id: flyoutID,
    css: cssStyles,
    className: classes,
    size: width,
    side: side,
    focusTrapProps: focusTrapProps,
    as: "nav",
    type: flyoutType,
    paddingSize: "none",
    pushMinBreakpoint: "xs",
    onClose: isPush ? onClose : closeOverlayFlyout,
    hideCloseButton: true
  }), children);
  var hideFlyout = isOverlay && !isOverlayOpen;
  return (0, _react2.jsx)(_context.EuiCollapsibleNavContext.Provider, {
    value: {
      isPush: isPush,
      isCollapsed: isCollapsed,
      isOverlayOpen: isOverlayOpen,
      side: side,
      closePortals: closeOverlayFlyout
    }
  }, (0, _react2.jsx)(_collapsible_nav_button.EuiCollapsibleNavButton, {
    ref: buttonRef,
    onClick: isPush ? toggleCollapsed : toggleOverlayFlyout,
    "aria-controls": flyoutID
  }), !hideFlyout && flyout);
};

/**
 * Combined export with subcomponents
 */
_EuiCollapsibleNavBeta.propTypes = {
  className: _propTypes.default.string,
  /**
       * Overlay flyouts are considered dialogs, and dialogs must have a label.
       * By default, a label of `Site menu` will be applied.
       *
       * If your usage of this component is not actually for site-wide navigation,
       * please set your own `aria-label` or `aria-labelledby`.
       *
       * @default 'Site menu'
       */
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * ReactNode(s) to render as navigation flyout content, typically `EuiCollapsibleNavBeta.Item`s.
       * You will likely want to use `EuiCollapsibleNavBeta.Body` and `EuiCollapsibleNavBeta.Footer`
       * for organization.
       */
  children: _propTypes.default.node,
  /**
       * Whether the navigation flyout should default to initially collapsed or expanded.
       * Used for **uncontrolled** state.
       */
  initialIsCollapsed: _propTypes.default.bool,
  /**
       * If defined, the navigation collapsed/expanded state is **controlled**
       * by the consumer and `onCollapseToggle` must be passed as well.
       * This prop supercedes `initialIsCollapsed`.
       */
  isCollapsed: _propTypes.default.bool,
  /**
       * Optional callback that fires when the user toggles the nav between
       * collapsed and uncollapsed states
       */
  onCollapseToggle: _propTypes.default.func,
  /**
       * Defaults to 248px wide. The navigation width determines behavior at
       * various responsive breakpoints.
       *
       * At larger screen sizes (at least 3x the width of the nav), the nav will
       * be able to be toggled between a docked full width nav and a collapsed
       * side bar that only shows the icon of each item.
       *
       * At under 3 times the width of the nav, the behavior will lose the collapsed
       * side bar behavior, and switch from a docked flyout to an overlay flyout only.
       *
       * If the page is under 1.5 times the width of the nav, the overlay will
       * take up the full width of the page.
       */
  width: _propTypes.default.number
};
var EuiCollapsibleNavBeta = exports.EuiCollapsibleNavBeta = Object.assign(_EuiCollapsibleNavBeta, {
  Body: _collapsible_nav_body_footer.EuiCollapsibleNavBody,
  Footer: _collapsible_nav_body_footer.EuiCollapsibleNavFooter,
  Item: _collapsible_nav_item.EuiCollapsibleNavItem,
  KibanaSolution: _kibana_solution.KibanaCollapsibleNavSolution
});