"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _button = require("../../button");
var _i18n = require("../../i18n");
var _context = require("../context");
var _collapsible_nav_button = require("./collapsible_nav_button.styles");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = require("@emotion/react");
var _excluded = ["className", "css"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiCollapsibleNavButton = exports.EuiCollapsibleNavButton = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var className = _ref.className,
    css = _ref.css,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useContext = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    side = _useContext.side,
    isPush = _useContext.isPush,
    isCollapsed = _useContext.isCollapsed,
    isOverlayOpen = _useContext.isOverlayOpen;
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav_button.euiCollapsibleNavButtonWrapperStyles);
  var cssStyles = [styles.euiCollapsibleNavButtonWrapper, styles[side]];
  var buttonStyles = [styles.euiCollapsibleNavButton, css];
  var classes = (0, _classnames.default)('euiCollapsibleNavButton', className);
  var toggleExpandLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavButton.ariaLabelExpand', 'Expand navigation');
  var toggleCollapseLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavButton.ariaLabelCollapse', 'Collapse navigation');
  var toggleOpenLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavButton.ariaLabelOpen', 'Open navigation');
  var toggleCloseLabel = (0, _i18n.useEuiI18n)('euiCollapsibleNavButton.ariaLabelClose', 'Close navigation');
  var ariaLabel;
  var iconType;
  if (isPush) {
    ariaLabel = isCollapsed ? toggleExpandLabel : toggleCollapseLabel;
    if (side === 'left') {
      iconType = isCollapsed ? 'menuRight' : 'menuLeft';
    } else {
      iconType = isCollapsed ? 'menuLeft' : 'menuRight';
    }
  } else {
    ariaLabel = isOverlayOpen ? toggleCloseLabel : toggleOpenLabel;
    iconType = isOverlayOpen ? 'cross' : 'menu';
  }
  return (0, _react2.jsx)("div", {
    className: "euiCollapsibleNavButtonWrapper",
    css: cssStyles,
    ref: ref
  }, (0, _react2.jsx)(_button.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "euiCollapsibleNavButton",
    className: classes,
    css: buttonStyles,
    size: "s",
    color: "text",
    iconType: iconType,
    "aria-label": ariaLabel,
    "aria-pressed": isPush ? !isCollapsed : isOverlayOpen,
    "aria-expanded": isPush ? !isCollapsed : isOverlayOpen
  }, rest)));
});
EuiCollapsibleNavButton.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};
EuiCollapsibleNavButton.displayName = 'EuiCollapsibleNavButton';