"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCollapsibleNavLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _link = require("../../link");
var _context = require("../context");
var _collapsible_nav_link = require("./collapsible_nav_link.styles");
var _react2 = require("@emotion/react");
var _excluded = ["href", "rel", "children", "className", "isSelected", "isInteractive", "isNotAccordion", "isSubItem", "linkProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/**
 * Internal nav link component.
 *
 * Can be rendered as a standalone nav item, or as part of an accordion header.
 * Can also be rendered as top-level item (has a background hover) or as a
 * sub-item (renders closer to plain text).
 *
 * In terms of DOM output, follows the same logic as EuiLink (renders either
 * an `a` tag or a `button` if no valid link exists), and can also additionally
 * rendered a plain `span` if the item is not interactive.
 */
var EuiCollapsibleNavLink = exports.EuiCollapsibleNavLink = function EuiCollapsibleNavLink(_ref) {
  var href = _ref.href,
    rel = _ref.rel,
    children = _ref.children,
    className = _ref.className,
    isSelected = _ref.isSelected,
    _ref$isInteractive = _ref.isInteractive,
    isInteractive = _ref$isInteractive === void 0 ? true : _ref$isInteractive,
    isNotAccordion = _ref.isNotAccordion,
    isSubItem = _ref.isSubItem,
    linkProps = _ref.linkProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiCollapsibleNavLink', className, isInteractive && (linkProps === null || linkProps === void 0 ? void 0 : linkProps.className));
  var styles = (0, _services.useEuiMemoizedStyles)(_collapsible_nav_link.euiCollapsibleNavLinkStyles);
  var cssStyles = [styles.euiCollapsibleNavLink, isSelected && styles.isSelected, isSubItem ? styles.isSubItem : styles.isTopItem.isTopItem, isNotAccordion && !isSubItem && styles.isTopItem.isNotAccordion, isInteractive && !isSelected && !isSubItem && styles.isTopItem.isInteractive, isInteractive && (linkProps === null || linkProps === void 0 ? void 0 : linkProps.css)];
  var _useContext = (0, _react.useContext)(_context.EuiCollapsibleNavContext),
    closePortals = _useContext.closePortals;
  var onClick = (0, _react.useCallback)(function (event) {
    var _rest$onClick, _linkProps$onClick;
    (_rest$onClick = rest.onClick) === null || _rest$onClick === void 0 || _rest$onClick.call(rest, event);
    linkProps === null || linkProps === void 0 || (_linkProps$onClick = linkProps.onClick) === null || _linkProps$onClick === void 0 || _linkProps$onClick.call(linkProps, event);
    if (!event.defaultPrevented) {
      closePortals === null || closePortals === void 0 || closePortals(event);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [rest.onClick, linkProps === null || linkProps === void 0 ? void 0 : linkProps.onClick, closePortals]);
  return isInteractive ? (0, _react2.jsx)(_link.EuiLink, (0, _extends2.default)({
    href: href,
    rel: rel
  }, _objectSpread(_objectSpread({}, rest), linkProps), {
    // EuiLink ExclusiveUnion shenanigans
    onClick: onClick,
    className: classes,
    css: cssStyles
  }), children) : (0, _react2.jsx)("span", (0, _extends2.default)({
    className: classes,
    css: cssStyles
  }, rest), children);
};
EuiCollapsibleNavLink.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Highlights whether an item is currently selected, e.g.
       * if the user is on the same page as the nav link
       */
  isSelected: _propTypes.default.bool,
  /**
     * Determines whether the item should render as a top-level nav item
     * or a nested nav subitem. Set internally by EUI
     */
  isSubItem: _propTypes.default.bool,
  children: _propTypes.default.node.isRequired,
  isInteractive: _propTypes.default.bool,
  isNotAccordion: _propTypes.default.bool
};