"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiColorPalettePicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _spacer = require("../../spacer");
var _text = require("../../text");
var _super_select = require("../../form/super_select");
var _color_palette_display = require("../color_palette_display");
var _react2 = require("@emotion/react");
var _excluded = ["className", "compressed", "disabled", "fullWidth", "isInvalid", "onChange", "readOnly", "valueOfSelected", "palettes", "append", "prepend", "selectionDisplay"],
  _excluded2 = ["type", "value", "title", "palette"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Note: needs to be pointed at this specific subdir for Storybook to inherit types correctly??
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var EuiColorPalettePicker = exports.EuiColorPalettePicker = function EuiColorPalettePicker(_ref) {
  var className = _ref.className,
    _ref$compressed = _ref.compressed,
    compressed = _ref$compressed === void 0 ? false : _ref$compressed,
    disabled = _ref.disabled,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    _ref$isInvalid = _ref.isInvalid,
    isInvalid = _ref$isInvalid === void 0 ? false : _ref$isInvalid,
    onChange = _ref.onChange,
    _ref$readOnly = _ref.readOnly,
    readOnly = _ref$readOnly === void 0 ? false : _ref$readOnly,
    valueOfSelected = _ref.valueOfSelected,
    palettes = _ref.palettes,
    append = _ref.append,
    prepend = _ref.prepend,
    _ref$selectionDisplay = _ref.selectionDisplay,
    selectionDisplay = _ref$selectionDisplay === void 0 ? 'palette' : _ref$selectionDisplay,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var getPalette = (0, _react.useCallback)(function (_ref2) {
    var type = _ref2.type,
      palette = _ref2.palette,
      title = _ref2.title;
    return (0, _react2.jsx)(_color_palette_display.EuiColorPaletteDisplay, {
      type: type,
      palette: palette,
      title: title
    });
  }, []);
  var paletteOptions = (0, _react.useMemo)(function () {
    return palettes.map(function (item) {
      var type = item.type,
        value = item.value,
        title = item.title,
        palette = item.palette,
        rest = (0, _objectWithoutProperties2.default)(item, _excluded2);
      var paletteForDisplay = item.type !== 'text' ? getPalette(item) : null;
      return _objectSpread({
        value: String(value),
        inputDisplay: selectionDisplay === 'title' || type === 'text' ? title : paletteForDisplay,
        dropdownDisplay: (0, _react2.jsx)("div", {
          className: "euiColorPalettePicker__item"
        }, title && type !== 'text' &&
        // Accessible labels are managed by color_palette_display_fixed and
        // color_palette_display_gradient. Adding the aria-hidden attribute
        // here to ensure screen readers don't speak the listbox options twice.
        (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_text.EuiText, {
          "aria-hidden": "true",
          className: "euiColorPalettePicker__itemTitle",
          size: "xs"
        }, title), (0, _react2.jsx)(_spacer.EuiSpacer, {
          size: "xs"
        })), type === 'text' ? title : paletteForDisplay)
      }, rest);
    });
  }, [getPalette, palettes, selectionDisplay]);
  return (0, _react2.jsx)(_super_select.EuiSuperSelect, (0, _extends2.default)({
    className: className,
    options: paletteOptions,
    valueOfSelected: valueOfSelected,
    onChange: onChange,
    hasDividers: true,
    isInvalid: isInvalid,
    compressed: compressed,
    disabled: disabled,
    readOnly: readOnly,
    fullWidth: fullWidth,
    append: append,
    prepend: prepend
  }, rest));
};
EuiColorPalettePicker.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  buttonRef: _propTypes.default.any,
  /**
     * @default false
     */
  compressed: _propTypes.default.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: _propTypes.default.bool,
  /**
     * @default false
     */
  isInvalid: _propTypes.default.bool,
  /**
     * @default false
     */
  isLoading: _propTypes.default.bool,
  readOnly: _propTypes.default.bool,
  name: _propTypes.default.string,
  /**
       * Placeholder to display when the current selected value is empty.
       */
  placeholder: _propTypes.default.node,
  /**
     * Creates an input group with element(s) coming before input.
     * `string` | `ReactElement` or an array of these
     */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
     * Creates an input group with element(s) coming after input.
     * `string` | `ReactElement` or an array of these
     */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  valueOfSelected: _propTypes.default.any,
  /**
       * Classes for the context menu item
       */
  itemClassName: _propTypes.default.string,
  /**
       * You must pass an `onChange` function to handle the update of the value
       */
  onChange: _propTypes.default.func,
  onFocus: _propTypes.default.func,
  onBlur: _propTypes.default.func,
  /**
       * Controls whether the options are shown. Default: false
       */
  isOpen: _propTypes.default.bool,
  /**
       * Optional props to pass to the underlying [EuiInputPopover](/#/layout/popover#popover-attached-to-input-element).
       * Allows fine-grained control of the popover dropdown menu, including
       * `repositionOnScroll` for EuiSuperSelects used within scrollable containers,
       * and customizing popover panel styling.
       *
       * Does not accept a nested `popoverProps.isOpen` property - use the top level
       * `isOpen` API instead.
       */
  popoverProps: _propTypes.default.any,
  /**
       *  Specify what should be displayed after a selection: a `palette` or `title`
       */
  selectionDisplay: _propTypes.default.oneOf(["palette", "title"]),
  /**
       * An array of one of the following objects: #EuiColorPalettePickerPaletteText, #EuiColorPalettePickerPaletteFixed, #EuiColorPalettePickerPaletteGradient
       */
  palettes: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
    /**
       *  For storing unique value of item
       */
    value: _propTypes.default.string.isRequired,
    /**
       *  The name of your palette
       */
    title: _propTypes.default.string.isRequired,
    /**
       * `text`: a text only option (a title is required).
       */
    type: _propTypes.default.oneOf(["text"]).isRequired,
    /**
       * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
       */
    palette: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired, _propTypes.default.arrayOf(_propTypes.default.shape({
      stop: _propTypes.default.number.isRequired,
      color: _propTypes.default.string.isRequired
    }).isRequired).isRequired]),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired, _propTypes.default.shape({
    /**
       *  For storing unique value of item
       */
    value: _propTypes.default.string.isRequired,
    /**
       *  The name of your palette
       */
    title: _propTypes.default.string,
    /**
       * `fixed`: individual color blocks
       */
    type: _propTypes.default.oneOf(["fixed"]).isRequired,
    /**
       * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
       */
    palette: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired, _propTypes.default.arrayOf(_propTypes.default.shape({
      stop: _propTypes.default.number.isRequired,
      color: _propTypes.default.string.isRequired
    }).isRequired).isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired, _propTypes.default.shape({
    /**
       *  For storing unique value of item
       */
    value: _propTypes.default.string.isRequired,
    /**
       *  The name of your palette
       */
    title: _propTypes.default.string,
    /**
       * `gradient`: each color fades into the next
       */
    type: _propTypes.default.oneOf(["gradient"]).isRequired,
    /**
       * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
       */
    palette: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired, _propTypes.default.arrayOf(_propTypes.default.shape({
      stop: _propTypes.default.number.isRequired,
      color: _propTypes.default.string.isRequired
    }).isRequired).isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired]).isRequired).isRequired
};