"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSaturation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _predicate = require("../../services/predicate");
var _global_styling = require("../../global_styling");
var _i18n = require("../i18n");
var _utils = require("./utils");
var _saturation = require("./saturation.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "color", "data-test-subj", "hex", "id", "onChange", "onKeyDown"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var colorDefaultValue = [1, 0, 0];
var EuiSaturation = exports.EuiSaturation = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var className = _ref.className,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? colorDefaultValue : _ref$color,
    _ref$dataTestSubj = _ref['data-test-subj'],
    dataTestSubj = _ref$dataTestSubj === void 0 ? 'euiSaturation' : _ref$dataTestSubj,
    hex = _ref.hex,
    _id = _ref.id,
    onChange = _ref.onChange,
    onKeyDown = _ref.onKeyDown,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiSaturation', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_saturation.euiSaturationStyles);
  var id = (0, _services.useGeneratedHtmlId)({
    conditionalId: _id
  });
  var instructionsId = "".concat(id, "-instructions");
  var indicatorId = "".concat(id, "-saturationIndicator");
  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiSaturation.ariaLabel', 'euiSaturation.screenReaderInstructions'], ['HSV color mode saturation and value 2-axis slider', "Arrow keys to navigate the square color gradient. Coordinates will be used to calculate HSV color mode 'saturation' and 'value' numbers, in the range of 0 to 1. Left and right to change the saturation. Up and down change the value."]),
    _useEuiI18n2 = (0, _slicedToArray2.default)(_useEuiI18n, 2),
    roleDescString = _useEuiI18n2[0],
    instructionsString = _useEuiI18n2[1];
  var _useState = (0, _react.useState)({
      left: 0,
      top: 0
    }),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    indicator = _useState2[0],
    setIndicator = _useState2[1];
  var _useState3 = (0, _react.useState)([]),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    lastColor = _useState4[0],
    setLastColor = _useState4[1];
  var boxRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    // Mimics `componentDidMount` and `componentDidUpdate`
    var _color = (0, _slicedToArray2.default)(color, 3),
      s = _color[1],
      v = _color[2];
    if (!(0, _predicate.isNil)(boxRef.current) && lastColor.join() !== color.join()) {
      var _boxRef$current$getBo = boxRef.current.getBoundingClientRect(),
        height = _boxRef$current$getBo.height,
        width = _boxRef$current$getBo.width;
      setIndicator({
        left: s * width,
        top: (1 - v) * height
      });
    }
  }, [color, lastColor]);
  var calculateColor = (0, _react.useCallback)(function (_ref2) {
    var top = _ref2.top,
      height = _ref2.height,
      left = _ref2.left,
      width = _ref2.width;
    var _color2 = (0, _slicedToArray2.default)(color, 1),
      h = _color2[0];
    var s = left / width;
    var v = 1 - top / height;
    return [h, s, v];
  }, [color]);
  var handleUpdate = (0, _react.useCallback)(function (box) {
    var left = box.left,
      top = box.top;
    setIndicator({
      left: left,
      top: top
    });
    var newColor = calculateColor(box);
    setLastColor(newColor);
    onChange(newColor);
  }, [calculateColor, onChange]);
  var handleChange = (0, _react.useCallback)(function (location) {
    if ((0, _predicate.isNil)(boxRef === null || boxRef === void 0 ? void 0 : boxRef.current)) return;
    var box = (0, _utils.getEventPosition)(location, boxRef.current);
    handleUpdate(box);
  }, [handleUpdate]);
  var _useMouseMove = (0, _services.useMouseMove)(handleChange, boxRef.current),
    _useMouseMove2 = (0, _slicedToArray2.default)(_useMouseMove, 2),
    handleMouseDown = _useMouseMove2[0],
    handleInteraction = _useMouseMove2[1];
  var handleKeyDown = (0, _react.useCallback)(function (event) {
    onKeyDown === null || onKeyDown === void 0 || onKeyDown(event);
    if ((0, _predicate.isNil)(boxRef === null || boxRef === void 0 ? void 0 : boxRef.current)) return;
    var _boxRef$current$getBo2 = boxRef.current.getBoundingClientRect(),
      height = _boxRef$current$getBo2.height,
      width = _boxRef$current$getBo2.width;
    var left = indicator.left,
      top = indicator.top;
    var heightScale = height / 100;
    var widthScale = width / 100;
    var newLeft = left;
    var newTop = top;
    switch (event.key) {
      case _services.keys.ARROW_DOWN:
        event.preventDefault();
        newTop = top < height ? top + heightScale : height;
        break;
      case _services.keys.ARROW_LEFT:
        event.preventDefault();
        newLeft = left > 0 ? left - widthScale : 0;
        break;
      case _services.keys.ARROW_UP:
        event.preventDefault();
        newTop = top > 0 ? top - heightScale : 0;
        break;
      case _services.keys.ARROW_RIGHT:
        event.preventDefault();
        newLeft = left < width ? left + widthScale : width;
        break;
      default:
        return;
    }
    var newPosition = {
      left: newLeft,
      top: newTop
    };
    setIndicator(newPosition);
    var newColor = calculateColor(_objectSpread({
      width: width,
      height: height
    }, newPosition));
    onChange(newColor);
  }, [calculateColor, indicator, onChange, onKeyDown]);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    onMouseDown: handleMouseDown,
    onTouchStart: handleInteraction,
    onTouchMove: handleInteraction,
    onKeyDown: handleKeyDown,
    ref: ref,
    css: styles.euiSaturation,
    className: classes,
    "data-test-subj": dataTestSubj,
    style: {
      background: "hsl(".concat(color[0], ", 100%, 50%)")
    },
    tabIndex: -1
  }, rest), (0, _react2.jsx)("div", {
    css: styles.euiSaturation__lightness,
    className: "euiSaturation__lightness",
    ref: boxRef
  }, (0, _react2.jsx)("div", {
    css: styles.euiSaturation__saturation,
    className: "euiSaturation__saturation"
  })), (0, _react2.jsx)("button", {
    id: indicatorId,
    css: styles.euiSaturation__indicator,
    className: "euiSaturation__indicator",
    style: (0, _global_styling.logicalStyles)(indicator),
    "aria-roledescription": roleDescString,
    "aria-label": hex,
    "aria-describedby": instructionsId
  }), (0, _react2.jsx)("span", {
    hidden: true,
    "aria-live": "assertive"
  }, hex), (0, _react2.jsx)("span", {
    hidden: true,
    id: instructionsId
  }, instructionsString));
});
EuiSaturation.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  color: _propTypes.default.any,
  onChange: _propTypes.default.func.isRequired,
  hex: _propTypes.default.string
};
EuiSaturation.displayName = 'EuiSaturation';