"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxOptionsList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactWindow = require("react-window");
var _services = require("../../../services");
var _flex = require("../../flex");
var _highlight = require("../../highlight");
var _mark = require("../../mark");
var _text = require("../../text");
var _loading = require("../../loading");
var _i18n = require("../../i18n");
var _filter_select_item = require("../../filter_group/filter_select_item");
var _badge = require("../../badge");
var _text_truncate = require("../../text_truncate");
var _input_popover = require("../../popover/input_popover");
var _utils = require("../utils");
var _combo_box_title = require("./combo_box_title");
var _combo_box_options_list = require("./combo_box_options_list.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children"],
  _excluded2 = ["key", "isGroupLabelOption", "label", "value", "prepend", "append", "truncationProps"],
  _excluded3 = ["data-test-subj", "activeOptionIndex", "areAllOptionsSelected", "customOptionText", "fullWidth", "getSelectedOptionForSearchValue", "isCaseSensitive", "isLoading", "listRef", "matchingOptions", "onCloseList", "onCreateOption", "onOptionClick", "onOptionEnterKey", "onScroll", "options", "renderOption", "rootId", "rowHeight", "scrollToIndex", "searchValue", "selectedOptions", "singleSelection", "delimiter", "truncationProps", "listboxAriaLabel"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var hitEnterBadge = (0, _react2.jsx)(_badge.EuiBadge, {
  className: "euiComboBoxOption__enterBadge",
  color: "hollow",
  iconType: "returnKey",
  "aria-hidden": "true"
});
var EuiComboBoxOptionsList = exports.EuiComboBoxOptionsList = /*#__PURE__*/function (_Component) {
  function EuiComboBoxOptionsList() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiComboBoxOptionsList);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiComboBoxOptionsList, [].concat(args));
    (0, _defineProperty2.default)(_this, "listRef", null);
    (0, _defineProperty2.default)(_this, "setListRef", function (ref) {
      _this.listRef = ref;
    });
    (0, _defineProperty2.default)(_this, "ListInnerElement", function (_ref) {
      var children = _ref.children,
        rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
      return (0, _react2.jsx)("div", (0, _extends2.default)({}, rest, {
        "aria-label": _this.props.listboxAriaLabel,
        id: _this.props.rootId('listbox'),
        role: "listbox",
        tabIndex: "0"
      }), children);
    });
    (0, _defineProperty2.default)(_this, "ListRow", function (_ref2) {
      var _option$key;
      var data = _ref2.data,
        index = _ref2.index,
        style = _ref2.style;
      var option = data[index];
      var key = option.key,
        isGroupLabelOption = option.isGroupLabelOption,
        label = option.label,
        value = option.value,
        prepend = option.prepend,
        append = option.append,
        _truncationProps = option.truncationProps,
        rest = (0, _objectWithoutProperties2.default)(option, _excluded2);
      var _this$props = _this.props,
        singleSelection = _this$props.singleSelection,
        selectedOptions = _this$props.selectedOptions,
        onOptionClick = _this$props.onOptionClick,
        activeOptionIndex = _this$props.activeOptionIndex,
        renderOption = _this$props.renderOption,
        searchValue = _this$props.searchValue,
        rootId = _this$props.rootId;
      var hasTruncationProps = _this.props.truncationProps || _truncationProps;
      var truncationProps = hasTruncationProps ? // Individual truncation settings should override component prop
      _objectSpread(_objectSpread({}, _this.props.truncationProps), _truncationProps) : undefined;
      if (isGroupLabelOption) {
        return (0, _react2.jsx)("div", {
          key: key !== null && key !== void 0 ? key : label,
          style: style
        }, (0, _react2.jsx)(_combo_box_title.EuiComboBoxTitle, null, prepend, label, append));
      }
      var checked = undefined;
      if (singleSelection && selectedOptions.length && selectedOptions[0].label === label && selectedOptions[0].key === key) {
        checked = 'on';
      }
      var optionIsFocused = activeOptionIndex === index;
      var optionIsDisabled = option.hasOwnProperty('disabled') && option.disabled === true;
      return (0, _react2.jsx)(_filter_select_item.EuiFilterSelectItem, (0, _extends2.default)({
        style: style,
        key: (_option$key = option.key) !== null && _option$key !== void 0 ? _option$key : option.label,
        onClick: function onClick() {
          if (onOptionClick) {
            onOptionClick(option);
          }
        },
        isFocused: optionIsFocused,
        checked: checked,
        showIcons: singleSelection ? true : false,
        id: rootId("_option-".concat(index)),
        title: label
      }, rest), (0, _react2.jsx)("span", {
        className: "euiComboBoxOption__contentWrapper"
      }, (0, _react2.jsx)(_utils.EuiComboBoxOptionAppendPrepend, {
        option: option,
        classNamePrefix: "euiComboBoxOption",
        marginSize: "s"
      }, (0, _react2.jsx)("span", {
        className: "euiComboBoxOption__content"
      }, renderOption ? renderOption(option, searchValue, 'euiComboBoxOption__renderOption') : _this.renderTruncatedOption(label, truncationProps))), optionIsFocused && !optionIsDisabled ? hitEnterBadge : null));
    });
    (0, _defineProperty2.default)(_this, "optionWidth", void 0);
    (0, _defineProperty2.default)(_this, "setOptionWidth", function (width) {
      _this.optionWidth = width;
    });
    (0, _defineProperty2.default)(_this, "renderTruncatedOption", function (text, truncationProps) {
      var searchValue = _this.props.searchValue.trim();
      if (!truncationProps && !searchValue) {
        // Default to CSS text-overflow
        return text;
      }
      if (!searchValue) {
        return (0, _react2.jsx)(_text_truncate.EuiTextTruncate, (0, _extends2.default)({
          width: _this.optionWidth,
          onResize: _this.setOptionWidth
        }, truncationProps, {
          text: text
        }), function (text) {
          return text;
        });
      }
      var searchPositionStart = _this.props.isCaseSensitive ? text.indexOf(searchValue) : text.toLowerCase().indexOf(searchValue.toLowerCase());
      var searchPositionCenter = searchPositionStart + Math.floor(searchValue.length / 2);
      return (0, _react2.jsx)(_text_truncate.EuiTextTruncate, (0, _extends2.default)({
        width: _this.optionWidth,
        onResize: _this.setOptionWidth
      }, truncationProps, {
        // When searching, don't allow overriding the truncation settings
        truncation: "startEnd",
        truncationPosition: searchPositionCenter,
        text: text
      }), function (text) {
        return (0, _react2.jsx)(_react.default.Fragment, null, text.length >= searchValue.length ? (0, _react2.jsx)(_highlight.EuiHighlight, {
          search: searchValue,
          strict: _this.props.isCaseSensitive
        }, text) :
        // If the available truncated text is shorter than the full search string,
        // just highlight the entire truncated text
        (0, _react2.jsx)(_mark.EuiMark, null, text));
      });
    });
    return _this;
  }
  (0, _inherits2.default)(EuiComboBoxOptionsList, _Component);
  return (0, _createClass2.default)(EuiComboBoxOptionsList, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.listRef && typeof this.props.activeOptionIndex !== 'undefined' && this.props.activeOptionIndex !== prevProps.activeOptionIndex) {
        this.listRef.scrollToItem(this.props.activeOptionIndex, 'auto');
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        dataTestSubj = _this$props2['data-test-subj'],
        activeOptionIndex = _this$props2.activeOptionIndex,
        areAllOptionsSelected = _this$props2.areAllOptionsSelected,
        customOptionText = _this$props2.customOptionText,
        fullWidth = _this$props2.fullWidth,
        getSelectedOptionForSearchValue = _this$props2.getSelectedOptionForSearchValue,
        isCaseSensitive = _this$props2.isCaseSensitive,
        isLoading = _this$props2.isLoading,
        listRef = _this$props2.listRef,
        matchingOptions = _this$props2.matchingOptions,
        onCloseList = _this$props2.onCloseList,
        onCreateOption = _this$props2.onCreateOption,
        onOptionClick = _this$props2.onOptionClick,
        onOptionEnterKey = _this$props2.onOptionEnterKey,
        onScroll = _this$props2.onScroll,
        options = _this$props2.options,
        renderOption = _this$props2.renderOption,
        rootId = _this$props2.rootId,
        rowHeight = _this$props2.rowHeight,
        scrollToIndex = _this$props2.scrollToIndex,
        searchValue = _this$props2.searchValue,
        selectedOptions = _this$props2.selectedOptions,
        singleSelection = _this$props2.singleSelection,
        delimiter = _this$props2.delimiter,
        truncationProps = _this$props2.truncationProps,
        listboxAriaLabel = _this$props2.listboxAriaLabel,
        rest = (0, _objectWithoutProperties2.default)(_this$props2, _excluded3);
      var emptyStateContent;
      if (isLoading) {
        emptyStateContent = (0, _react2.jsx)(_flex.EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "center",
          responsive: false
        }, (0, _react2.jsx)(_flex.EuiFlexItem, {
          grow: false
        }, (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
          size: "m"
        })), (0, _react2.jsx)(_flex.EuiFlexItem, {
          grow: false
        }, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiComboBoxOptionsList.loadingOptions",
          default: "Loading options"
        })));
      } else if (searchValue && matchingOptions && matchingOptions.length === 0) {
        if (onCreateOption && getSelectedOptionForSearchValue) {
          if (delimiter && searchValue.includes(delimiter)) {
            emptyStateContent = (0, _react2.jsx)("div", {
              className: "euiComboBoxOption__contentWrapper"
            }, (0, _react2.jsx)("p", {
              className: "euiComboBoxOption__emptyStateText"
            }, (0, _react2.jsx)(_i18n.EuiI18n, {
              token: "euiComboBoxOptionsList.delimiterMessage",
              default: "Add each item separated by {delimiter}",
              values: {
                delimiter: (0, _react2.jsx)("strong", null, delimiter)
              }
            })), hitEnterBadge);
          } else {
            var selectedOptionForValue = getSelectedOptionForSearchValue({
              isCaseSensitive: isCaseSensitive,
              searchValue: searchValue,
              selectedOptions: selectedOptions
            });
            if (selectedOptionForValue) {
              // Disallow duplicate custom options.
              emptyStateContent = (0, _react2.jsx)("p", null, (0, _react2.jsx)(_i18n.EuiI18n, {
                token: "euiComboBoxOptionsList.alreadyAdded",
                default: "{label} has already been added",
                values: {
                  label: (0, _react2.jsx)("strong", null, selectedOptionForValue.label)
                }
              }));
            } else {
              var highlightSearchValue = function highlightSearchValue(text, searchValue) {
                var reg = new RegExp(/(\{searchValue})/, 'gi');
                var parts = text.split(reg);
                return (0, _react2.jsx)("p", {
                  className: "euiComboBoxOption__emptyStateText"
                }, parts.map(function (part, idx) {
                  return part.match(reg) ? (0, _react2.jsx)("strong", {
                    key: idx
                  }, searchValue) : part;
                }));
              };
              emptyStateContent = (0, _react2.jsx)("div", {
                className: "euiComboBoxOption__contentWrapper"
              }, customOptionText ? highlightSearchValue(customOptionText, searchValue) : (0, _react2.jsx)("p", {
                className: "euiComboBoxOption__emptyStateText"
              }, (0, _react2.jsx)(_i18n.EuiI18n, {
                token: "euiComboBoxOptionsList.createCustomOption",
                default: "Add {searchValue} as a custom option",
                values: {
                  searchValue: (0, _react2.jsx)("strong", null, searchValue)
                }
              })), hitEnterBadge);
            }
          }
        } else {
          emptyStateContent = (0, _react2.jsx)("p", null, (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiComboBoxOptionsList.noMatchingOptions",
            default: "{searchValue} doesn't match any options",
            values: {
              searchValue: (0, _react2.jsx)("strong", null, searchValue)
            }
          }));
        }
      } else if (!options.length) {
        emptyStateContent = (0, _react2.jsx)("p", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiComboBoxOptionsList.noAvailableOptions",
          default: "There aren't any options available"
        }));
      } else if (areAllOptionsSelected) {
        emptyStateContent = (0, _react2.jsx)("p", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiComboBoxOptionsList.allOptionsSelected",
          default: "You've selected all available options"
        }));
      }
      var numVisibleOptions = matchingOptions.length < 7 ? matchingOptions.length : 7;
      var height = numVisibleOptions * (rowHeight + 1); // Add one for the border

      // bounded by max-height of .euiComboBoxOptionsList
      var boundedHeight = height > _combo_box_options_list.LIST_MAX_HEIGHT ? _combo_box_options_list.LIST_MAX_HEIGHT : height;
      return (0, _react2.jsx)(_services.RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
        var styles = stylesMemoizer(_combo_box_options_list.euiComboBoxOptionListStyles);
        return (0, _react2.jsx)("div", (0, _extends2.default)({
          css: styles.euiComboBoxOptionList,
          className: "euiComboBoxOptionsList",
          "data-test-subj": (0, _classnames.default)('comboBoxOptionsList', dataTestSubj),
          ref: listRef
        }, rest), emptyStateContent ? (0, _react2.jsx)(_text.EuiText, {
          size: "xs",
          css: styles.euiComboBoxOptionsList__empty,
          className: "euiComboBoxOptionsList__empty"
        }, emptyStateContent) : (0, _react2.jsx)(_reactWindow.FixedSizeList, {
          css: styles.euiComboBoxOptionList__virtualization,
          className: "euiComboBoxOptionsList__virtualization",
          height: boundedHeight,
          onScroll: onScroll,
          itemCount: matchingOptions.length,
          itemSize: rowHeight,
          itemData: matchingOptions,
          ref: _this2.setListRef,
          innerElementType: _this2.ListInnerElement,
          width: _this2.context
        }, _this2.ListRow));
      });
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiComboBoxOptionsList, "contextType", _input_popover.EuiInputPopoverWidthContext);
(0, _defineProperty2.default)(EuiComboBoxOptionsList, "defaultProps", {
  'data-test-subj': '',
  rowHeight: 29,
  // row height of default option renderer
  isCaseSensitive: false
});
EuiComboBoxOptionsList.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  activeOptionIndex: _propTypes.default.number,
  areAllOptionsSelected: _propTypes.default.bool,
  listboxAriaLabel: _propTypes.default.string.isRequired,
  /**
     * Creates a custom text option. You can use `{searchValue}` inside your string to better customize your text.
     * It won't show if there's no onCreateOption.
     */
  customOptionText: _propTypes.default.string,
  fullWidth: _propTypes.default.bool,
  getSelectedOptionForSearchValue: _propTypes.default.func,
  isCaseSensitive: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,
  listRef: _propTypes.default.any.isRequired,
  matchingOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    key: _propTypes.default.string,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      key: _propTypes.default.string,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any,
      prepend: _propTypes.default.node,
      append: _propTypes.default.node,
      truncationProps: _propTypes.default.any,
      /**
         * Optional custom tooltip content for the button
         */
      toolTipContent: _propTypes.default.node,
      /**
         * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
         */
      toolTipProps: _propTypes.default.any,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any
    }).isRequired),
    value: _propTypes.default.any,
    prepend: _propTypes.default.node,
    append: _propTypes.default.node,
    truncationProps: _propTypes.default.any,
    /**
       * Optional custom tooltip content for the button
       */
    toolTipContent: _propTypes.default.node,
    /**
       * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
       */
    toolTipProps: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired).isRequired,
  onCloseList: _propTypes.default.func.isRequired,
  onCreateOption: _propTypes.default.func,
  onOptionClick: _propTypes.default.func,
  onOptionEnterKey: _propTypes.default.func,
  onScroll: _propTypes.default.any,
  /**
     * Array of EuiComboBoxOptionOption objects. See #EuiComboBoxOptionOption
     */
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    key: _propTypes.default.string,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      key: _propTypes.default.string,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any,
      prepend: _propTypes.default.node,
      append: _propTypes.default.node,
      truncationProps: _propTypes.default.any,
      toolTipContent: _propTypes.default.node,
      toolTipProps: _propTypes.default.any,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any
    }).isRequired),
    value: _propTypes.default.any,
    prepend: _propTypes.default.node,
    append: _propTypes.default.node,
    truncationProps: _propTypes.default.any,
    toolTipContent: _propTypes.default.node,
    toolTipProps: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired).isRequired,
  renderOption: _propTypes.default.func,
  rootId: _propTypes.default.any.isRequired,
  rowHeight: _propTypes.default.number.isRequired,
  scrollToIndex: _propTypes.default.number,
  searchValue: _propTypes.default.string.isRequired,
  selectedOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    key: _propTypes.default.string,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      key: _propTypes.default.string,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any,
      prepend: _propTypes.default.node,
      append: _propTypes.default.node,
      truncationProps: _propTypes.default.any,
      toolTipContent: _propTypes.default.node,
      toolTipProps: _propTypes.default.any,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any
    }).isRequired),
    value: _propTypes.default.any,
    prepend: _propTypes.default.node,
    append: _propTypes.default.node,
    truncationProps: _propTypes.default.any,
    toolTipContent: _propTypes.default.node,
    toolTipProps: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired).isRequired,
  singleSelection: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    asPlainText: _propTypes.default.bool
  }).isRequired]),
  delimiter: _propTypes.default.string,
  truncationProps: _propTypes.default.any
};