"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxOptionAppendPrepend = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * DRY util for rendering an option with its prepend and append properties
 */
var EuiComboBoxOptionAppendPrepend = exports.EuiComboBoxOptionAppendPrepend = function EuiComboBoxOptionAppendPrepend(_ref) {
  var children = _ref.children,
    option = _ref.option,
    classNamePrefix = _ref.classNamePrefix,
    _ref$marginSize = _ref.marginSize,
    marginSize = _ref$marginSize === void 0 ? 'xs' : _ref$marginSize;
  var _useEuiTheme = (0, _services.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme;
  var margin = euiTheme.size[marginSize];
  return (0, _react.jsx)(_react2.default.Fragment, null, (option === null || option === void 0 ? void 0 : option.prepend) && (0, _react.jsx)("span", {
    className: "".concat(classNamePrefix, "__prepend"),
    css: /*#__PURE__*/(0, _react.css)(_objectSpread(_objectSpread({}, (0, _global_styling.logicalStyle)('margin-right', margin)), centerIcons), ";label:EuiComboBoxOptionAppendPrepend;")
  }, option.prepend), children, (option === null || option === void 0 ? void 0 : option.append) && (0, _react.jsx)("span", {
    className: "".concat(classNamePrefix, "__append"),
    css: /*#__PURE__*/(0, _react.css)(_objectSpread(_objectSpread({}, (0, _global_styling.logicalStyle)('margin-left', margin)), centerIcons), ";label:EuiComboBoxOptionAppendPrepend;")
  }, option.append));
};

// Fix vertical alignment of EuiIcons in prepend/append nodes
var centerIcons = {
  '.euiIcon': {
    display: 'block'
  }
};