"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiContextMenuClass = exports.EuiContextMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _horizontal_rule = require("../horizontal_rule");
var _context_menu_panel = require("./context_menu_panel");
var _context_menu_item = require("./context_menu_item");
var _context_menu = require("./context_menu.styles");
var _react2 = require("@emotion/react");
var _excluded = ["isSeparator", "key"],
  _excluded2 = ["panel", "name", "key", "icon", "onClick"],
  _excluded3 = ["stylesMemoizer", "panels", "onPanelChange", "className", "initialPanelId", "size"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var SIZES = exports.SIZES = ['s', 'm'];
var isItemSeparator = function isItemSeparator(item) {
  return item.isSeparator === true;
};
function mapIdsToPanels(panels) {
  var map = {};
  panels.forEach(function (panel) {
    map[panel.id] = panel;
  });
  return map;
}
function mapIdsToPreviousPanels(panels) {
  var idToPreviousPanelIdMap = {};
  panels.forEach(function (panel) {
    if (Array.isArray(panel.items)) {
      panel.items.forEach(function (item) {
        if (isItemSeparator(item)) return;
        var isCloseable = item.panel !== undefined;
        if (isCloseable) {
          idToPreviousPanelIdMap[item.panel] = panel.id;
        }
      });
    }
  });
  return idToPreviousPanelIdMap;
}
function mapPanelItemsToPanels(panels) {
  var idAndItemIndexToPanelIdMap = {};
  panels.forEach(function (panel) {
    idAndItemIndexToPanelIdMap[panel.id] = {};
    if (panel.items) {
      panel.items.forEach(function (item, index) {
        if (isItemSeparator(item)) return;
        if (item.panel) {
          idAndItemIndexToPanelIdMap[panel.id][index] = item.panel;
        }
      });
    }
  });
  return idAndItemIndexToPanelIdMap;
}
var EuiContextMenuClass = exports.EuiContextMenuClass = /*#__PURE__*/function (_Component) {
  function EuiContextMenuClass(props) {
    var _this;
    (0, _classCallCheck2.default)(this, EuiContextMenuClass);
    _this = _callSuper(this, EuiContextMenuClass, [props]);
    (0, _defineProperty2.default)(_this, "hasPreviousPanel", function (panelId) {
      var previousPanelId = _this.state.idToPreviousPanelIdMap[panelId];
      return typeof previousPanelId !== 'undefined';
    });
    (0, _defineProperty2.default)(_this, "showNextPanel", function (itemIndex) {
      if (itemIndex == null) {
        return;
      }
      var nextPanelId = _this.state.idAndItemIndexToPanelIdMap[_this.state.incomingPanelId][itemIndex];
      if (nextPanelId) {
        if (_this.state.isUsingKeyboardToNavigate) {
          _this.setState(function (_ref) {
            var idToPanelMap = _ref.idToPanelMap;
            return {
              focusedItemIndex: idToPanelMap[nextPanelId].initialFocusedItemIndex
            };
          });
        }
        _this.showPanel(nextPanelId, 'next');
      }
    });
    (0, _defineProperty2.default)(_this, "showPreviousPanel", function () {
      // If there's a previous panel, then we can close the current panel to go back to it.
      if (_this.hasPreviousPanel(_this.state.incomingPanelId)) {
        var previousPanelId = _this.state.idToPreviousPanelIdMap[_this.state.incomingPanelId];

        // Set focus on the item which shows the panel we're leaving.
        var previousPanel = _this.state.idToPanelMap[previousPanelId];
        var focusedItemIndex = previousPanel.items.filter(function (item) {
          return !isItemSeparator(item);
        }).findIndex(function (item) {
          return item.panel === _this.state.incomingPanelId;
        });
        if (focusedItemIndex !== -1) {
          _this.setState({
            focusedItemIndex: focusedItemIndex
          });
        }
        _this.showPanel(previousPanelId, 'previous');
      }
    });
    (0, _defineProperty2.default)(_this, "onIncomingPanelHeightChange", function (height) {
      _this.setState(function (_ref2) {
        var prevHeight = _ref2.height;
        if (height === prevHeight) {
          return null;
        }
        return {
          height: height
        };
      });
    });
    (0, _defineProperty2.default)(_this, "onOutGoingPanelTransitionComplete", function () {
      _this.setState({
        isOutgoingPanelVisible: false
      });
    });
    (0, _defineProperty2.default)(_this, "onUseKeyboardToNavigate", function () {
      if (!_this.state.isUsingKeyboardToNavigate) {
        _this.setState({
          isUsingKeyboardToNavigate: true
        });
      }
    });
    (0, _defineProperty2.default)(_this, "mapIdsToRenderedItems", function () {
      var panels = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var idToRenderedItemsMap = {};

      // Pre-rendering the items lets us check reference equality inside of EuiContextMenuPanel.
      panels.forEach(function (panel) {
        idToRenderedItemsMap[panel.id] = _this.renderItems(panel.items);
      });
      return idToRenderedItemsMap;
    });
    _this.state = {
      prevProps: {},
      idToPanelMap: {},
      idToPreviousPanelIdMap: {},
      idAndItemIndexToPanelIdMap: {},
      idToRenderedItemsMap: _this.mapIdsToRenderedItems(_this.props.panels),
      height: undefined,
      outgoingPanelId: undefined,
      incomingPanelId: props.initialPanelId,
      transitionDirection: undefined,
      isOutgoingPanelVisible: false,
      focusedItemIndex: undefined,
      isUsingKeyboardToNavigate: false
    };
    return _this;
  }
  (0, _inherits2.default)(EuiContextMenuClass, _Component);
  return (0, _createClass2.default)(EuiContextMenuClass, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.panels !== this.props.panels) {
        this.setState({
          idToRenderedItemsMap: this.mapIdsToRenderedItems(this.props.panels)
        });
      }
    }
  }, {
    key: "showPanel",
    value: function showPanel(panelId, direction) {
      var _this$props$onPanelCh, _this$props;
      this.setState({
        outgoingPanelId: this.state.incomingPanelId,
        incomingPanelId: panelId,
        transitionDirection: direction,
        isOutgoingPanelVisible: true
      });
      (_this$props$onPanelCh = (_this$props = this.props).onPanelChange) === null || _this$props$onPanelCh === void 0 || _this$props$onPanelCh.call(_this$props, {
        panelId: panelId,
        direction: direction
      });
    }
  }, {
    key: "renderItems",
    value: function renderItems() {
      var _this2 = this;
      var items = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      return items.map(function (item, index) {
        if (item.renderItem) {
          var _item$key;
          return (0, _react2.jsx)(_react.Fragment, {
            key: (_item$key = item.key) !== null && _item$key !== void 0 ? _item$key : index
          }, item.renderItem());
        }
        if (isItemSeparator(item)) {
          var omit = item.isSeparator,
            _item$key2 = item.key,
            _key = _item$key2 === void 0 ? index : _item$key2,
            _rest = (0, _objectWithoutProperties2.default)(item, _excluded);
          return (0, _react2.jsx)(_horizontal_rule.EuiHorizontalRule, (0, _extends2.default)({
            key: _key,
            margin: "none"
          }, _rest));
        }
        var panel = item.panel,
          name = item.name,
          key = item.key,
          icon = item.icon,
          onClick = item.onClick,
          rest = (0, _objectWithoutProperties2.default)(item, _excluded2);
        var onClickHandler = panel ? function (event) {
          if (onClick && event) {
            event.persist();
          }
          // This component is commonly wrapped in a EuiOutsideClickDetector, which means we'll
          // need to wait for that logic to complete before re-rendering the DOM via showPanel.
          window.requestAnimationFrame(function () {
            if (onClick) {
              onClick(event);
            }
            _this2.showNextPanel(index);
          });
        } : onClick;
        return (0, _react2.jsx)(_context_menu_item.EuiContextMenuItem, (0, _extends2.default)({
          key: key || (typeof name === 'string' ? name : undefined) || index,
          icon: icon,
          onClick: onClickHandler,
          hasPanel: Boolean(panel)
        }, rest), name);
      });
    }
  }, {
    key: "renderPanel",
    value: function renderPanel(panelId, transitionType) {
      var _this3 = this;
      var panel = this.state.idToPanelMap[panelId];
      if (!panel) {
        return;
      }

      // As above, we need to wait for EuiOutsideClickDetector to complete its logic before
      // re-rendering via showPanel.
      var onClose;
      if (this.hasPreviousPanel(panelId)) {
        onClose = function onClose() {
          return window.requestAnimationFrame(_this3.showPreviousPanel);
        };
      }
      var cssStyles = {
        position: 'absolute',
        label: 'euiContextMenu__panel'
      };
      return (0, _react2.jsx)(_context_menu_panel.EuiContextMenuPanel, {
        key: panelId,
        size: this.props.size,
        css: cssStyles,
        onHeightChange: transitionType === 'in' ? this.onIncomingPanelHeightChange : undefined,
        onTransitionComplete: transitionType === 'out' ? this.onOutGoingPanelTransitionComplete : undefined,
        title: panel.title,
        onClose: onClose,
        transitionType: this.state.isOutgoingPanelVisible ? transitionType : undefined,
        transitionDirection: this.state.isOutgoingPanelVisible ? this.state.transitionDirection : undefined,
        items: this.state.idToRenderedItemsMap[panelId],
        initialFocusedItemIndex: this.state.isUsingKeyboardToNavigate ? this.state.focusedItemIndex : panel.initialFocusedItemIndex,
        onUseKeyboardToNavigate: this.onUseKeyboardToNavigate,
        showNextPanel: this.showNextPanel,
        showPreviousPanel: this.showPreviousPanel
      }, panel.content);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        stylesMemoizer = _this$props2.stylesMemoizer,
        panels = _this$props2.panels,
        onPanelChange = _this$props2.onPanelChange,
        className = _this$props2.className,
        initialPanelId = _this$props2.initialPanelId,
        size = _this$props2.size,
        rest = (0, _objectWithoutProperties2.default)(_this$props2, _excluded3);
      var incomingPanel = this.renderPanel(this.state.incomingPanelId, 'in');
      var outgoingPanel;
      if (this.state.isOutgoingPanelVisible) {
        outgoingPanel = this.renderPanel(this.state.outgoingPanelId, 'out');
      }
      var width = this.state.idToPanelMap[this.state.incomingPanelId] && this.state.idToPanelMap[this.state.incomingPanelId].width ? this.state.idToPanelMap[this.state.incomingPanelId].width : undefined;
      var classes = (0, _classnames.default)('euiContextMenu', className);
      var styles = stylesMemoizer(_context_menu.euiContextMenuStyles);
      return (0, _react2.jsx)("div", (0, _extends2.default)({
        css: styles.euiContextMenu,
        className: classes,
        style: {
          height: this.state.height,
          width: width
        }
      }, rest), outgoingPanel, incomingPanel);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var panels = nextProps.panels;
      if (panels && prevState.prevProps.panels !== panels) {
        return {
          prevProps: {
            panels: panels
          },
          idToPanelMap: mapIdsToPanels(panels),
          idToPreviousPanelIdMap: mapIdsToPreviousPanels(panels),
          idAndItemIndexToPanelIdMap: mapPanelItemsToPanels(panels)
        };
      }
      return null;
    }
  }]);
}(_react.Component);
(0, _defineProperty2.default)(EuiContextMenuClass, "defaultProps", {
  panels: [],
  size: 'm'
});
EuiContextMenuClass.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  panels: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired,
    title: _propTypes.default.node,
    items: _propTypes.default.arrayOf(_propTypes.default.shape({
      name: _propTypes.default.node,
      key: _propTypes.default.string,
      panel: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),
      isSeparator: _propTypes.default.oneOf([true]),
      /**
         * Defines the width of the HR.
         */
      size: _propTypes.default.any,
      margin: _propTypes.default.any,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,
      css: _propTypes.default.any,
      /**
         * Allows rendering any custom content alongside your array of context menu items.
         * Accepts either a component or an inline function component that returns any JSX.
         */
      renderItem: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.func.isRequired])
    }).isRequired),
    content: _propTypes.default.node,
    width: _propTypes.default.any,
    initialFocusedItemIndex: _propTypes.default.number,
    /**
       * Alters the size of the items and the title
       */
    size: _propTypes.default.any
  }).isRequired),
  /**
       * Optional callback that fires on every panel change. Passes back
       * the new panel ID and whether its direction was `next` or `previous`.
       */
  onPanelChange: _propTypes.default.func,
  initialPanelId: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),
  /**
       * Alters the size of the items and the title
       */
  size: _propTypes.default.any
};
var EuiContextMenu = exports.EuiContextMenu = (0, _services.withEuiStylesMemoizer)(EuiContextMenuClass);