"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _button = require("../button");
var _copy = require("./copy");
var _form = require("../form");
var _spacer = require("../spacer");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var Copy = function Copy() {
  var _useState = (0, _react.useState)('I am the text that will be copied'),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    copyText = _useState2[0],
    setCopyText = _useState2[1];
  return (0, _react2.jsx)("div", null, (0, _react2.jsx)(_form.EuiFormRow, {
    label: "Enter text that will be copied to clipboard"
  }, (0, _react2.jsx)(_form.EuiFieldText, {
    value: copyText,
    onChange: function onChange(e) {
      return setCopyText(e.target.value);
    }
  })), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m"
  }), (0, _react2.jsx)(_copy.EuiCopy, {
    textToCopy: copyText
  }, function (copy) {
    return (0, _react2.jsx)(_button.EuiButton, {
      onClick: copy,
      "data-test-subj": "cy-copy-button"
    }, "Click to copy input text");
  }));
};
beforeEach(function () {
  cy.realMount((0, _react2.jsx)(Copy, null));
});
describe('EuiCopy', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations after the copy button is clicked', function () {
      cy.get('button[data-test-subj="cy-copy-button"]').realClick();
      cy.checkAxe();
    });
    it('has zero violations after keyboard interaction', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Enter');
      cy.checkAxe();
    });
  });
});