"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridFooterRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../../services");
var _cell = require("../cell");
var _data_grid_footer = require("./data_grid_footer.styles");
var _react2 = require("@emotion/react");
var _excluded = ["leadingControlColumns", "trailingControlColumns", "columns", "schema", "columnWidths", "defaultColumnWidth", "className", "renderCellValue", "renderCellPopover", "rowIndex", "interactiveCellId", "data-test-subj", "visibleRowIndex", "visibleColCount", "gridStyles"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var renderEmpty = function renderEmpty() {
  return null;
};
var EuiDataGridFooterRow = exports.EuiDataGridFooterRow = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    columns = _ref.columns,
    schema = _ref.schema,
    columnWidths = _ref.columnWidths,
    defaultColumnWidth = _ref.defaultColumnWidth,
    className = _ref.className,
    renderCellValue = _ref.renderCellValue,
    renderCellPopover = _ref.renderCellPopover,
    rowIndex = _ref.rowIndex,
    interactiveCellId = _ref.interactiveCellId,
    _dataTestSubj = _ref['data-test-subj'],
    _ref$visibleRowIndex = _ref.visibleRowIndex,
    visibleRowIndex = _ref$visibleRowIndex === void 0 ? rowIndex : _ref$visibleRowIndex,
    visibleColCount = _ref.visibleColCount,
    gridStyles = _ref.gridStyles,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_data_grid_footer.euiDataGridFooterStyles);
  var cssStyles = [styles.euiDataGridFooter, gridStyles.stickyFooter && styles.sticky, gridStyles.footer === 'striped' ? visibleRowIndex % 2 !== 0 && styles.striped : styles[gridStyles.footer]];
  var classes = (0, _classnames.default)('euiDataGridFooter', className);
  var dataTestSubj = (0, _classnames.default)('dataGridRow', 'dataGridFooterRow', _dataTestSubj);
  var getCellClasses = (0, _react.useCallback)(function (columnIndex, classes) {
    return (0, _classnames.default)('euiDataGridFooterCell', {
      'euiDataGridRowCell--firstColumn': columnIndex === 0,
      'euiDataGridRowCell--lastColumn': columnIndex === visibleColCount - 1
    }, classes);
  }, [visibleColCount]);
  var popoverContext = (0, _react.useContext)(_cell.DataGridCellPopoverContext);
  var sharedCellProps = {
    css: styles.euiDataGridFooterCell,
    rowIndex: rowIndex,
    visibleRowIndex: visibleRowIndex,
    interactiveCellId: interactiveCellId,
    popoverContext: popoverContext,
    gridStyles: gridStyles
  };
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    ref: ref,
    role: "row",
    css: cssStyles,
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (_ref2, i) {
    var id = _ref2.id,
      width = _ref2.width,
      footerCellRender = _ref2.footerCellRender,
      footerCellProps = _ref2.footerCellProps;
    return (0, _react2.jsx)(_cell.EuiDataGridCell, (0, _extends2.default)({}, footerCellProps, sharedCellProps, {
      key: "".concat(id, "-").concat(rowIndex),
      colIndex: i,
      columnId: id,
      width: width,
      renderCellValue: footerCellRender !== null && footerCellRender !== void 0 ? footerCellRender : renderEmpty,
      isExpandable: false,
      className: getCellClasses(i, (0, _classnames.default)('euiDataGridRowCell--controlColumn', footerCellProps === null || footerCellProps === void 0 ? void 0 : footerCellProps.className))
    }));
  }), columns.map(function (_ref3, i) {
    var id = _ref3.id;
    var columnType = schema[id] ? schema[id].columnType : null;
    var width = columnWidths[id] || defaultColumnWidth;
    var columnPosition = i + leadingControlColumns.length;
    return (0, _react2.jsx)(_cell.EuiDataGridCell, (0, _extends2.default)({}, sharedCellProps, {
      key: "".concat(columnPosition, ",").concat(visibleRowIndex) // Note: this key should use cell position to match react-window/data cell behavior. See #5720
      ,
      colIndex: columnPosition,
      columnId: id,
      columnType: columnType,
      width: width || undefined,
      renderCellValue: renderCellValue,
      renderCellPopover: renderCellPopover,
      isExpandable: true,
      className: getCellClasses(columnPosition)
    }));
  }), trailingControlColumns.map(function (_ref4, i) {
    var id = _ref4.id,
      width = _ref4.width,
      footerCellRender = _ref4.footerCellRender,
      footerCellProps = _ref4.footerCellProps;
    var colIndex = i + columns.length + leadingControlColumns.length;
    return (0, _react2.jsx)(_cell.EuiDataGridCell, (0, _extends2.default)({}, footerCellProps, sharedCellProps, {
      key: "".concat(id, "-").concat(rowIndex),
      colIndex: colIndex,
      columnId: id,
      width: width,
      renderCellValue: footerCellRender !== null && footerCellRender !== void 0 ? footerCellRender : renderEmpty,
      isExpandable: false,
      className: getCellClasses(colIndex, (0, _classnames.default)('euiDataGridRowCell--controlColumn', footerCellProps === null || footerCellProps === void 0 ? void 0 : footerCellProps.className))
    }));
  }));
}));
EuiDataGridFooterRow.displayName = 'EuiDataGridFooterRow';