"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridFooter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _resize_observer = require("../../../observer/resize_observer");
var _data_grid_footer_row = require("./data_grid_footer_row");
var _react2 = require("@emotion/react");
var _excluded = ["renderFooterCellValue"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * DRY out setting up the grid footer and its refs & observers
 */
var useDataGridFooter = exports.useDataGridFooter = function useDataGridFooter(props) {
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    footerRowRef = _useState2[0],
    setFooterRowRef = _useState2[1];
  var _useResizeObserver = (0, _resize_observer.useResizeObserver)(footerRowRef, 'height'),
    footerRowHeight = _useResizeObserver.height;
  var footerRow = (0, _react.useMemo)(function () {
    var renderFooterCellValue = props.renderFooterCellValue,
      footerProps = (0, _objectWithoutProperties2.default)(props, _excluded);
    if (renderFooterCellValue == null) return null;
    return (0, _react2.jsx)(_data_grid_footer_row.EuiDataGridFooterRow, (0, _extends2.default)({
      ref: setFooterRowRef,
      renderCellValue: renderFooterCellValue
    }, footerProps));
  }, [props]);
  return {
    footerRow: footerRow,
    footerRowHeight: footerRowHeight
  };
};