"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridColumnResizer = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../../services");
var _global_styling = require("../../../../global_styling");
var _draggable_columns = require("./draggable_columns");
var _column_resizer = require("./column_resizer.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var MINIMUM_COLUMN_WIDTH = 40;
var EuiDataGridColumnResizer = exports.EuiDataGridColumnResizer = /*#__PURE__*/function (_Component) {
  function EuiDataGridColumnResizer() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiDataGridColumnResizer);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiDataGridColumnResizer, [].concat(args));
    (0, _defineProperty2.default)(_this, "state", {
      initialX: 0,
      offset: 0
    });
    (0, _defineProperty2.default)(_this, "onMouseDown", function (e) {
      _this.setState({
        initialX: e.pageX
      });
      window.addEventListener('mouseup', _this.onMouseUp);
      window.addEventListener('blur', _this.onMouseUp);
      window.addEventListener('mousemove', _this.onMouseMove);

      // don't let this action steal focus
      e.preventDefault();
    });
    (0, _defineProperty2.default)(_this, "onMouseUp", function () {
      var offset = _this.state.offset;
      var _this$props = _this.props,
        columnId = _this$props.columnId,
        columnWidth = _this$props.columnWidth,
        setColumnWidth = _this$props.setColumnWidth;
      setColumnWidth(columnId, Math.max(MINIMUM_COLUMN_WIDTH, columnWidth + offset));
      _this.setState({
        offset: 0
      });
      window.removeEventListener('mouseup', _this.onMouseUp);
      window.removeEventListener('blur', _this.onMouseUp);
      window.removeEventListener('mousemove', _this.onMouseMove);
    });
    (0, _defineProperty2.default)(_this, "onMouseMove", function (e) {
      var columnWidth = _this.props.columnWidth;
      _this.setState(function (_ref) {
        var initialX = _ref.initialX;
        return {
          offset: Math.max(e.pageX - initialX, -(columnWidth - MINIMUM_COLUMN_WIDTH))
        };
      });
    });
    return _this;
  }
  (0, _inherits2.default)(EuiDataGridColumnResizer, _Component);
  return (0, _createClass2.default)(EuiDataGridColumnResizer, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var offset = this.state.offset;
      var isLastColumn = this.props.isLastColumn;
      return (0, _react2.jsx)(_services.RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
        var styles = stylesMemoizer(_column_resizer.euiDataGridColumnResizerStyles);
        var cssStyles = [styles.euiDataGridColumnResizer, isLastColumn && styles.isLastColumn, offset && styles.isDragging];
        return (0, _react2.jsx)("div", {
          css: cssStyles,
          className: "euiDataGridColumnResizer",
          "data-test-subj": "dataGridColumnResizer",
          style: offset ? (0, _global_styling.logicalStyle)('margin-right', "".concat(-offset, "px")) : undefined,
          onMouseDown: _this2.onMouseDown
        }, (0, _react2.jsx)(_draggable_columns.DragOverlay, {
          isDragging: !!offset,
          cursor: "ew-resize"
        }));
      });
    }
  }]);
}(_react.Component);
EuiDataGridColumnResizer.propTypes = {
  columnId: _propTypes.default.string.isRequired,
  columnWidth: _propTypes.default.number.isRequired,
  setColumnWidth: _propTypes.default.func.isRequired,
  isLastColumn: _propTypes.default.bool.isRequired
};