"use strict";

var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumnSorting = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../../services");
var _i18n = require("../../../i18n");
var _icon = require("../../../icon");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Keep the i18n scope the same as EuiDataGridHeaderCell
/* eslint-disable local/i18n */

/**
 * Column sorting utility helpers
 */
var useColumnSorting = exports.useColumnSorting = function useColumnSorting(_ref) {
  var _sorting$columns;
  var sorting = _ref.sorting,
    id = _ref.id,
    hasColumnActions = _ref.hasColumnActions;
  var sortedColumn = (0, _react.useMemo)(function () {
    return sorting === null || sorting === void 0 ? void 0 : sorting.columns.find(function (col) {
      return col.id === id;
    });
  }, [sorting, id]);
  var isColumnSorted = !!sortedColumn;
  var hasOnlyOneSort = (sorting === null || sorting === void 0 || (_sorting$columns = sorting.columns) === null || _sorting$columns === void 0 ? void 0 : _sorting$columns.length) === 1;

  /**
   * Arrow icon
   */
  var sortingArrow = (0, _react.useMemo)(function () {
    return isColumnSorted ? (0, _react2.jsx)(_icon.EuiIcon, {
      type: sortedColumn.direction === 'asc' ? 'sortUp' : 'sortDown',
      color: "text",
      className: "euiDataGridHeaderCell__sortingArrow",
      "data-test-subj": "dataGridHeaderCellSortingIcon-".concat(id)
    }) : null;
  }, [id, isColumnSorted, sortedColumn]);

  /**
   * aria-sort attribute - should only be used when a single column is being sorted
   * @see https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-sort
   * @see https://www.w3.org/WAI/ARIA/apg/example-index/table/sortable-table.html
   * @see https://github.com/w3c/aria/issues/283 for potential future multi-column usage
   */
  var ariaSort = isColumnSorted && hasOnlyOneSort ? sorting.columns[0].direction === 'asc' ? 'ascending' : 'descending' : undefined;

  // aria-describedby ID for when aria-sort isn't sufficient
  var sortingAriaId = (0, _services.useGeneratedHtmlId)({
    prefix: 'euiDataGridCellHeader',
    suffix: 'sorting'
  });

  /**
   * Sorting status - screen reader text
   */
  var sortingScreenReaderText = (0, _react.useMemo)(function () {
    var _sorting$columns2;
    if (!isColumnSorted) return null;
    if (!hasColumnActions && hasOnlyOneSort) return null; // in this scenario, the `aria-sort` attribute will be used by screen readers
    return (0, _react2.jsx)("p", {
      id: sortingAriaId,
      hidden: true
    }, sorting === null || sorting === void 0 || (_sorting$columns2 = sorting.columns) === null || _sorting$columns2 === void 0 ? void 0 : _sorting$columns2.map(function (_ref2, index) {
      var columnId = _ref2.id,
        direction = _ref2.direction;
      if (hasOnlyOneSort) {
        if (direction === 'asc') {
          return (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiDataGridHeaderCell.sortedByAscendingSingle",
            default: "Sorted ascending",
            key: index
          });
        } else {
          return (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiDataGridHeaderCell.sortedByDescendingSingle",
            default: "Sorted descending",
            key: index
          });
        }
      } else if (index === 0) {
        if (direction === 'asc') {
          return (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiDataGridHeaderCell.sortedByAscendingFirst",
            default: "Sorted by {columnId}, ascending",
            values: {
              columnId: columnId
            },
            key: index
          });
        } else {
          return (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiDataGridHeaderCell.sortedByDescendingFirst",
            default: "Sorted by {columnId}, descending",
            values: {
              columnId: columnId
            },
            key: index
          });
        }
      } else {
        if (direction === 'asc') {
          return (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiDataGridHeaderCell.sortedByAscendingMultiple",
            default: ", then sorted by {columnId}, ascending",
            values: {
              columnId: columnId
            },
            key: index
          });
        } else {
          return (0, _react2.jsx)(_i18n.EuiI18n, {
            token: "euiDataGridHeaderCell.sortedByDescendingMultiple",
            default: ", then sorted by {columnId}, descending",
            values: {
              columnId: columnId
            },
            key: index
          });
        }
      }
    }), ".");
  }, [isColumnSorted, hasColumnActions, hasOnlyOneSort, sorting, sortingAriaId]);
  return {
    sortingArrow: sortingArrow,
    ariaSort: ariaSort,
    sortingAriaId: sortingAriaId,
    sortingScreenReaderText: sortingScreenReaderText
  };
};