"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridHeaderCellWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../../services");
var _focus = require("../../utils/focus");
var _focus_utils = require("../cell/focus_utils");
var _data_grid_header_cell_wrapper = require("./data_grid_header_cell_wrapper.styles");
var _react2 = require("@emotion/react");
var _excluded = ["id", "index", "isLastColumn", "width", "className", "children", "hasColumnActions", "isDragging", "onKeyDown", "aria-label"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * This is a wrapper that handles repeated concerns between control &
 * standard header cells. Most of its shared logic is around focus state/UX,
 * but it also DRY's out certain class/data-test-subj/style attributes
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var EuiDataGridHeaderCellWrapper = exports.EuiDataGridHeaderCellWrapper = function EuiDataGridHeaderCellWrapper(_ref) {
  var id = _ref.id,
    index = _ref.index,
    isLastColumn = _ref.isLastColumn,
    width = _ref.width,
    className = _ref.className,
    children = _ref.children,
    hasColumnActions = _ref.hasColumnActions,
    isDragging = _ref.isDragging,
    _onKeyDown = _ref.onKeyDown,
    ariaLabel = _ref['aria-label'],
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiDataGridHeaderCell', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_data_grid_header_cell_wrapper.euiDataGridHeaderCellWrapperStyles);

  // Must be a state and not a ref to trigger a HandleInteractiveChildren rerender
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    headerEl = _useState2[0],
    setHeaderEl = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    renderFocusTrap = _useState4[0],
    setRenderFocusTrap = _useState4[1];
  var _useState5 = (0, _react.useState)([]),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    interactiveChildren = _useState6[0],
    setInteractiveChildren = _useState6[1];
  (0, _react.useEffect)(function () {
    // We're checking for interactive children outside of the default actions button
    setRenderFocusTrap(interactiveChildren.length > (hasColumnActions ? 1 : 0));
  }, [hasColumnActions, interactiveChildren]);
  var _useContext = (0, _react.useContext)(_focus.DataGridFocusContext),
    setFocusedCell = _useContext.setFocusedCell,
    onFocusUpdate = _useContext.onFocusUpdate;
  var updateCellFocusContext = (0, _react.useCallback)(function () {
    setFocusedCell([index, -1]);
  }, [index, setFocusedCell]);
  var _useState7 = (0, _react.useState)(false),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    isFocused = _useState8[0],
    setIsFocused = _useState8[1];
  (0, _react.useEffect)(function () {
    onFocusUpdate([index, -1], function (isFocused) {
      setIsFocused(isFocused);
      if (isFocused && headerEl) {
        // Only focus the cell if not already focused on something in the cell
        if (!headerEl.contains(document.activeElement)) {
          headerEl.focus();
        }
      }
    });
  }, [index, onFocusUpdate, headerEl]);
  var onKeyDown = (0, _react.useCallback)(function (e) {
    // Ignore keys that conflict with the focus trap being entered/exited
    if (renderFocusTrap && (e.key === _services.keys.ENTER || e.key === _services.keys.ESCAPE)) {
      return;
    }
    // Otherwise, continue with whatever onKeyDown is being passed
    _onKeyDown === null || _onKeyDown === void 0 || _onKeyDown(e);
  }, [_onKeyDown, renderFocusTrap]);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    role: "columnheader",
    ref: setHeaderEl,
    tabIndex: isFocused ? 0 : -1,
    onKeyDown: onKeyDown,
    css: styles.euiDataGridHeaderCell,
    className: classes,
    "data-test-subj": "dataGridHeaderCell-".concat(id),
    "data-gridcell-column-id": id,
    "data-gridcell-column-index": index,
    "data-gridcell-row-index": "-1",
    "data-gridcell-visible-row-index": "-1",
    style: width != null ? {
      width: "".concat(width, "px")
    } : {},
    "aria-label": renderFocusTrap ? ariaLabel : undefined
  }, rest), (0, _react2.jsx)(_focus_utils.HandleInteractiveChildren, {
    cellEl: isDragging ? null : headerEl,
    renderFocusTrap: isDragging ? false : renderFocusTrap,
    updateCellFocusContext: updateCellFocusContext,
    onInteractiveChildrenFound: setInteractiveChildren
  }, typeof children === 'function' ? children(renderFocusTrap) : children), isLastColumn ? _services.tabularCopyMarkers.hiddenNewline : _services.tabularCopyMarkers.hiddenTab);
};
EuiDataGridHeaderCellWrapper.propTypes = {
  children: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.func.isRequired]).isRequired,
  id: _propTypes.default.string.isRequired,
  index: _propTypes.default.number.isRequired,
  isLastColumn: _propTypes.default.bool.isRequired,
  width: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.oneOf([null])]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.any,
  hasColumnActions: _propTypes.default.bool,
  isDragging: _propTypes.default.bool,
  onKeyDown: _propTypes.default.any
};