"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _resize_observer = require("../../../observer/resize_observer");
var _data_grid_header_row = require("./data_grid_header_row");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * DRY out setting up the grid header and its refs & observers
 */
var useDataGridHeader = exports.useDataGridHeader = function useDataGridHeader(props) {
  var _useState = (0, _react.useState)(null),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    headerRowRef = _useState2[0],
    setHeaderRowRef = _useState2[1];
  var _useResizeObserver = (0, _resize_observer.useResizeObserver)(headerRowRef, 'height'),
    headerRowHeight = _useResizeObserver.height;
  var headerRow = (0, _react.useMemo)(function () {
    return (0, _react2.jsx)(_data_grid_header_row.EuiDataGridHeaderRow, (0, _extends2.default)({
      ref: setHeaderRowRef
    }, props));
  }, [props]);
  return (0, _react.useMemo)(function () {
    return {
      headerRow: headerRow,
      headerRowHeight: headerRowHeight
    };
  }, [headerRow, headerRowHeight]);
};