"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridDisplaySelector = exports.startingStyles = void 0;
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _isEqual = _interopRequireDefault(require("lodash/isEqual"));
var _global_styling = require("../../../global_styling");
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _popover = require("../../popover");
var _button = require("../../button");
var _form = require("../../form");
var _form2 = require("../../form/form.styles");
var _flex = require("../../flex");
var _tool_tip = require("../../tool_tip");
var _data_grid_toolbar = require("./data_grid_toolbar");
var _react2 = require("@emotion/react");
var _excluded = ["onChange"],
  _excluded2 = ["onChange"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof3(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var startingStyles = exports.startingStyles = {
  cellPadding: 'm',
  fontSize: 'm',
  border: 'all',
  stripes: false,
  rowHover: 'highlight',
  header: 'shade',
  footer: 'overline',
  stickyFooter: true
};
var emptyRowHeightsOptions = {};

/**
 * Cell density
 */

var densityOptions = ['compact', 'normal', 'expanded'];
var densityStyles = {
  expanded: {
    fontSize: 'l',
    cellPadding: 'l'
  },
  normal: {
    fontSize: 'm',
    cellPadding: 'm'
  },
  compact: {
    fontSize: 's',
    cellPadding: 's'
  }
};
var convertGridStylesToSelection = function convertGridStylesToSelection(gridStyles) {
  if (gridStyles.fontSize === 's' && gridStyles.cellPadding === 's') return 'compact';
  if (gridStyles.fontSize === 'm' && gridStyles.cellPadding === 'm') return 'normal';
  if (gridStyles.fontSize === 'l' && gridStyles.cellPadding === 'l') return 'expanded';
  return '';
};
var DensityControl = function DensityControl(_ref) {
  var gridStyles = _ref.gridStyles,
    onChange = _ref.onChange;
  var getDensity = (0, _react.useMemo)(function () {
    return convertGridStylesToSelection(gridStyles);
  }, [gridStyles]);
  var setDensity = (0, _react.useCallback)(function (density) {
    onChange(densityStyles[density]);
  }, [onChange]);
  return (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiDisplaySelector.densityLabel', 'euiDisplaySelector.labelCompact', 'euiDisplaySelector.labelNormal', 'euiDisplaySelector.labelExpanded'],
    defaults: ['Density', 'Compact', 'Normal', 'Expanded']
  }, function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 4),
      densityLabel = _ref3[0],
      labelCompact = _ref3[1],
      labelNormal = _ref3[2],
      labelExpanded = _ref3[3];
    return (0, _react2.jsx)(_form.EuiFormRow, {
      label: densityLabel,
      display: "columnCompressed"
    }, (0, _react2.jsx)(_button.EuiButtonGroup, {
      legend: densityLabel,
      buttonSize: "compressed",
      isFullWidth: true,
      options: [{
        id: densityOptions[0],
        label: labelCompact
      }, {
        id: densityOptions[1],
        label: labelNormal
      }, {
        id: densityOptions[2],
        label: labelExpanded
      }],
      onChange: setDensity,
      idSelected: getDensity,
      "data-test-subj": "densityButtonGroup"
    }));
  });
};

/**
 * Row heights
 */

var rowHeightSelectionOptions = ['auto', 'static'];
var convertRowHeightsOptionsToSelection = function convertRowHeightsOptionsToSelection(rowHeightsOptions) {
  var defaultHeight = rowHeightsOptions.defaultHeight;

  // Custom pixel row height values don't have a corresponding UI element
  if (typeof defaultHeight === 'number' || (0, _typeof2.default)(defaultHeight) === 'object' && defaultHeight.height) {
    return '';
  }
  if (defaultHeight === 'auto') {
    return rowHeightSelectionOptions[0];
  }
  return rowHeightSelectionOptions[1];
};
var _ref7 = process.env.NODE_ENV === "production" ? {
  name: "ueqtrq-RowHeightControl",
  styles: "flex-shrink:0;flex-basis:66.6%;label:RowHeightControl;"
} : {
  name: "ueqtrq-RowHeightControl",
  styles: "flex-shrink:0;flex-basis:66.6%;label:RowHeightControl;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var RowHeightControl = function RowHeightControl(_ref4) {
  var rowHeightsOptions = _ref4.rowHeightsOptions,
    onChange = _ref4.onChange;
  var autoBelowLineCount = rowHeightsOptions.autoBelowLineCount;
  var _useState = (0, _react.useState)(1),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    lineCountInput = _useState2[0],
    setLineCountInput = _useState2[1];
  var setLineCountHeight = (0, _react.useCallback)(function (event) {
    var newLineCount = Number(event.currentTarget.value);
    setLineCountInput(newLineCount);
    onChange({
      rowHeights: {},
      // Unset all row-specific line counts
      defaultHeight: newLineCount > 1 ? {
        lineCount: newLineCount
      } : undefined // lineCount: 1 is the same as undefined, and this helps correctly display the reset button
    });
  }, [onChange]);
  (0, _react.useEffect)(function () {
    var passedLineCount = (0, _typeof2.default)(rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight) === 'object' ? rowHeightsOptions.defaultHeight.lineCount : undefined;

    // If lineCount updates come in from consumer changes, update the input to reflect that
    if (passedLineCount) {
      setLineCountInput(passedLineCount);
    }
    // If set back to undefined/single line height (typically from the reset button)
    if ((rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight) === undefined) {
      setLineCountInput(1);
    }
  }, [rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight]);
  var rowHeightSelection = (0, _react.useMemo)(function () {
    return convertRowHeightsOptionsToSelection(rowHeightsOptions);
  }, [rowHeightsOptions]);
  var setRowHeight = (0, _react.useCallback)(function (option) {
    var rowHeightsOptions = {
      rowHeights: {} // Unset all row-specific heights
    };
    if (option === rowHeightSelectionOptions[0]) {
      rowHeightsOptions.defaultHeight = 'auto';
    } else if (option === rowHeightSelectionOptions[1]) {
      var lineCount = Number(lineCountInput);
      if (lineCount > 1) {
        rowHeightsOptions.defaultHeight = {
          lineCount: lineCount
        };
      } else {
        // lineCount: 1 is the same as single/undefined
        rowHeightsOptions.defaultHeight = undefined;
      }
    }
    onChange(rowHeightsOptions);
  }, [lineCountInput, onChange]);
  return (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiDisplaySelector.rowHeightLabel', 'euiDisplaySelector.labelAuto', 'euiDisplaySelector.labelStatic', 'euiDisplaySelector.labelMax'],
    defaults: ['Lines per row', 'Auto', 'Static', 'Max']
  }, function (_ref5) {
    var _ref6 = (0, _slicedToArray2.default)(_ref5, 4),
      rowHeightLabel = _ref6[0],
      labelAuto = _ref6[1],
      labelStatic = _ref6[2],
      labelMax = _ref6[3];
    return (0, _react2.jsx)(_form.EuiFormRow, {
      label: rowHeightLabel,
      display: "columnCompressed"
    }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false
    }, (0, _react2.jsx)(_button.EuiButtonGroup, {
      legend: rowHeightLabel,
      css: _ref7,
      buttonSize: "compressed",
      isFullWidth: true,
      options: [{
        id: rowHeightSelectionOptions[0],
        label: labelAuto
      }, {
        id: rowHeightSelectionOptions[1],
        label: autoBelowLineCount ? labelMax : labelStatic
      }],
      onChange: setRowHeight,
      idSelected: rowHeightSelection,
      "data-test-subj": "rowHeightButtonGroup"
    }), (0, _react2.jsx)(_form.EuiFieldNumber, {
      "aria-label": rowHeightLabel,
      compressed: true,
      min: 1,
      max: 20,
      disabled: rowHeightSelection !== rowHeightSelectionOptions[1],
      value: lineCountInput,
      onChange: setLineCountHeight,
      "data-test-subj": "lineCountNumber"
    })));
  });
};

/**
 * Display settings/selector popover
 */

var useDataGridDisplaySelector = exports.useDataGridDisplaySelector = function useDataGridDisplaySelector(showDisplaySelector, passedGridStyles) {
  var _showDisplaySelector$;
  var passedRowHeightsOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : emptyRowHeightsOptions;
  /**
   * Grid style changes
   */
  var _useState3 = (0, _react.useState)(passedGridStyles),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    gridStyles = _useState4[0],
    setGridStyles = _useState4[1];

  // Update if consumers pass new grid style configurations
  var stablePassedGridStyles = (0, _services.useDeepEqual)(passedGridStyles);
  (0, _services.useUpdateEffect)(function () {
    setGridStyles(stablePassedGridStyles);
  }, [stablePassedGridStyles]);

  // Update on user display selector change
  var onUserGridStyleChange = (0, _react.useCallback)(function (styles) {
    return setGridStyles(function (prevStyles) {
      var changedStyles = _objectSpread(_objectSpread({}, prevStyles), styles);
      var onChange = changedStyles.onChange,
        rest = (0, _objectWithoutProperties2.default)(changedStyles, _excluded);
      onChange === null || onChange === void 0 || onChange(rest);
      return changedStyles;
    });
  }, []);
  var densityControl = (0, _react.useMemo)(function () {
    var show = (0, _data_grid_toolbar.getNestedObjectOptions)(showDisplaySelector, 'allowDensity');
    return show ? (0, _react2.jsx)(DensityControl, {
      gridStyles: gridStyles,
      onChange: onUserGridStyleChange
    }) : null;
  }, [showDisplaySelector, gridStyles, onUserGridStyleChange]);

  /**
   * Row height changes
   */
  var _useState5 = (0, _react.useState)(passedRowHeightsOptions),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    rowHeightsOptions = _useState6[0],
    setRowHeightsOptions = _useState6[1];

  // Update if consumers pass new row height configurations
  var stablePassedRowHeights = (0, _services.useDeepEqual)(passedRowHeightsOptions);
  (0, _services.useUpdateEffect)(function () {
    setRowHeightsOptions(stablePassedRowHeights);
  }, [stablePassedRowHeights]);

  // Update on user display selector change
  var onUserRowHeightChange = (0, _react.useCallback)(function (options) {
    return setRowHeightsOptions(function (prevOptions) {
      var changedOptions = _objectSpread(_objectSpread({}, prevOptions), options);
      var onChange = changedOptions.onChange,
        rest = (0, _objectWithoutProperties2.default)(changedOptions, _excluded2);
      onChange === null || onChange === void 0 || onChange(rest);
      return changedOptions;
    });
  }, []);
  var rowHeightControl = (0, _react.useMemo)(function () {
    var show = (0, _data_grid_toolbar.getNestedObjectOptions)(showDisplaySelector, 'allowRowHeight');
    return show ? (0, _react2.jsx)(RowHeightControl, {
      rowHeightsOptions: rowHeightsOptions,
      onChange: onUserRowHeightChange
    }) : null;
  }, [showDisplaySelector, rowHeightsOptions, onUserRowHeightChange]);

  /**
   * Reset button
   */
  var _useState7 = (0, _react.useState)(false),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    showResetButton = _useState8[0],
    setShowResetButton = _useState8[1];
  var initialGridStyles = (0, _react.useRef)(passedGridStyles);
  var initialRowHeightsOptions = (0, _react.useRef)(passedRowHeightsOptions);
  var resetToInitialState = (0, _react.useCallback)(function () {
    setGridStyles(initialGridStyles.current);
    setRowHeightsOptions(initialRowHeightsOptions.current);
  }, []);
  (0, _services.useUpdateEffect)(function () {
    setShowResetButton(!(0, _isEqual.default)(rowHeightsOptions.defaultHeight, initialRowHeightsOptions.current.defaultHeight) || gridStyles.fontSize !== initialGridStyles.current.fontSize || gridStyles.cellPadding !== initialGridStyles.current.cellPadding);
  }, [rowHeightsOptions.defaultHeight, gridStyles.fontSize, gridStyles.cellPadding]);
  var resetButton = (0, _react.useMemo)(function () {
    var allowed = (0, _data_grid_toolbar.getNestedObjectOptions)(showDisplaySelector, 'allowResetButton');
    if (!allowed || !showResetButton) return null;
    return (0, _react2.jsx)(ResetButton, {
      onClick: resetToInitialState
    });
  }, [showDisplaySelector, showResetButton, resetToInitialState]);

  /**
   * Display settings popover
   */
  var _useState9 = (0, _react.useState)(false),
    _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
    isOpen = _useState10[0],
    setIsOpen = _useState10[1];
  var buttonLabel = (0, _i18n.useEuiI18n)('euiDisplaySelector.buttonText', 'Display options');
  var additionalDisplaySettings = typeof showDisplaySelector === 'boolean' ? null : (_showDisplaySelector$ = showDisplaySelector === null || showDisplaySelector === void 0 ? void 0 : showDisplaySelector.additionalDisplaySettings) !== null && _showDisplaySelector$ !== void 0 ? _showDisplaySelector$ : null;
  var customRender = typeof showDisplaySelector === 'boolean' ? undefined : showDisplaySelector === null || showDisplaySelector === void 0 ? void 0 : showDisplaySelector.customRender;
  var euiTheme = (0, _services.useEuiTheme)();
  var displaySelector = (0, _react.useMemo)(function () {
    var paddingSize = 's';
    var formMaxWidth = (0, _form2.euiFormMaxWidth)(euiTheme);
    var popoverWidth = (0, _global_styling.mathWithUnits)([formMaxWidth, euiTheme.euiTheme.size[paddingSize]], function (x, y) {
      return x + y * 2;
    });
    return densityControl || rowHeightControl || additionalDisplaySettings ? (0, _react2.jsx)(_popover.EuiPopover, {
      "data-test-subj": "dataGridDisplaySelectorPopover",
      isOpen: isOpen,
      closePopover: function closePopover() {
        return setIsOpen(false);
      },
      anchorPosition: "downRight",
      panelPaddingSize: paddingSize,
      panelProps: {
        css: (0, _global_styling.logicalStyle)('width', popoverWidth)
      },
      panelClassName: "euiDataGrid__displayPopoverPanel",
      button: (0, _react2.jsx)(_tool_tip.EuiToolTip, {
        content: buttonLabel,
        delay: "long"
      }, (0, _react2.jsx)(_button.EuiButtonIcon, {
        size: "xs",
        iconType: "controlsHorizontal",
        color: "text",
        "data-test-subj": "dataGridDisplaySelectorButton",
        onClick: function onClick() {
          return setIsOpen(!isOpen);
        },
        "aria-label": buttonLabel
      }))
    }, customRender ? customRender({
      densityControl: densityControl,
      rowHeightControl: rowHeightControl,
      additionalDisplaySettings: additionalDisplaySettings,
      resetButton: resetButton
    }) : (0, _react2.jsx)(_react.default.Fragment, null, densityControl, rowHeightControl, additionalDisplaySettings, resetButton)) : null;
  }, [euiTheme, densityControl, rowHeightControl, additionalDisplaySettings, resetButton, customRender, buttonLabel, isOpen]);
  return [displaySelector, gridStyles, rowHeightsOptions];
};
var ResetButton = function ResetButton(_ref8) {
  var onClick = _ref8.onClick;
  var resetButtonLabel = (0, _i18n.useEuiI18n)('euiDisplaySelector.resetButtonText', 'Reset to default');
  return (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: false
  }, (0, _react2.jsx)(_button.EuiButtonEmpty, {
    flush: "both",
    size: "xs",
    onClick: onClick,
    "data-test-subj": "resetDisplaySelector"
  }, resetButtonLabel)));
};