"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridKeyboardShortcuts = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _button = require("../../button");
var _tool_tip = require("../../tool_tip");
var _popover = require("../../popover");
var _description_list = require("../../description_list");
var _text = require("../../text");
var _i18n = require("../../i18n");
var _keyboard_shortcuts = require("./keyboard_shortcuts.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var useDataGridKeyboardShortcuts = exports.useDataGridKeyboardShortcuts = function useDataGridKeyboardShortcuts() {
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var title = (0, _i18n.useEuiI18n)('euiKeyboardShortcuts.title', 'Keyboard shortcuts');
  var titleId = (0, _services.useGeneratedHtmlId)();
  var styles = (0, _services.useEuiMemoizedStyles)(_keyboard_shortcuts.euiDataGridKeyboardShortcutsStyles);
  var keyboardShortcuts = (0, _react.useMemo)(function () {
    return (0, _react2.jsx)(_popover.EuiPopover, {
      "data-test-subj": "dataGridKeyboardShortcutsPopover",
      isOpen: isOpen,
      closePopover: function closePopover() {
        return setIsOpen(false);
      },
      anchorPosition: "downRight",
      panelPaddingSize: "none",
      button: (0, _react2.jsx)(_tool_tip.EuiToolTip, {
        content: title,
        delay: "long"
      }, (0, _react2.jsx)(_button.EuiButtonIcon, {
        size: "xs",
        iconType: "keyboard",
        color: "text",
        "data-test-subj": "dataGridKeyboardShortcutsButton",
        onClick: function onClick() {
          return setIsOpen(!isOpen);
        },
        "aria-label": title
      }))
    }, (0, _react2.jsx)(_popover.EuiPopoverTitle, {
      paddingSize: "s"
    }, (0, _react2.jsx)("h2", {
      id: titleId
    }, title)), (0, _react2.jsx)(_text.EuiText, {
      css: styles.euiDataGrid__keyboardShortcuts,
      className: "euiDataGrid__keyboardShortcuts",
      size: "xs"
    }, (0, _react2.jsx)(_description_list.EuiDescriptionList, {
      "aria-labelledby": titleId,
      type: "column",
      columnWidths: ['auto', 'auto'],
      align: "center",
      compressed: true,
      listItems: [{
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.upArrowTitle",
          default: "Up arrow"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.upArrowDescription",
          default: "Move one cell up"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.downArrowTitle",
          default: "Down arrow"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.downArrowDescription",
          default: "Move one cell down"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.rightArrowTitle",
          default: "Right arrow"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.rightArrowDescription",
          default: "Move one cell right"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.leftArrowTitle",
          default: "Left arrow"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.leftArrowDescription",
          default: "Move one cell left"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.homeTitle",
          default: "Home"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.homeDescription",
          default: "Move to the first cell of the current row"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.endTitle",
          default: "End"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.endDescription",
          default: "Move to the last cell of the current row"
        })
      }, {
        title: (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.ctrl",
          default: "Ctrl"
        })), ' ', (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.homeTitle",
          default: "Home"
        }))),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.ctrlHomeDescription",
          default: "Move to the first cell of the current page"
        })
      }, {
        title: (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.ctrl",
          default: "Ctrl"
        })), ' ', (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.endTitle",
          default: "End"
        }))),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.ctrlEndDescription",
          default: "Move to the last cell of the current page"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.pageUpTitle",
          default: "Page Up"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.pageUpDescription",
          default: "Go to the last row of the previous page"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.pageDownTitle",
          default: "Page Down"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.pageDownDescription",
          default: "Go to the first row of the next page"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.enterTitle",
          default: "Enter"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.enterDescription",
          default: "Open cell details and actions"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.escapeTitle",
          default: "Escape"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.escapeDescription",
          default: "Close cell details and actions"
        })
      }]
    })));
  }, [isOpen, title, titleId, styles]);
  return {
    keyboardShortcuts: keyboardShortcuts
  };
};