"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDefaultColumnWidth = exports.useColumnWidths = exports.doesColumnHaveAnInitialWidth = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _react = require("react");
var _services = require("../../../services");
var _utils = require("../../../utils");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var DEFAULT_COLUMN_WIDTH = 100;
var useDefaultColumnWidth = exports.useDefaultColumnWidth = function useDefaultColumnWidth(gridWidth, leadingControlColumns, trailingControlColumns, columns) {
  var defaultColumnWidth = (0, _react.useMemo)(function () {
    if (_utils.IS_JEST_ENVIRONMENT) return DEFAULT_COLUMN_WIDTH;
    if (gridWidth === 0) return null; // we can't tell what size to compute yet

    var controlColumnWidths = [].concat((0, _toConsumableArray2.default)(leadingControlColumns), (0, _toConsumableArray2.default)(trailingControlColumns)).reduce(function (claimedWidth, controlColumn) {
      return claimedWidth + controlColumn.width;
    }, 0);
    var columnsWithWidths = columns.filter(doesColumnHaveAnInitialWidth);
    var definedColumnsWidth = columnsWithWidths.reduce(function (claimedWidth, column) {
      return claimedWidth + column.initialWidth;
    }, 0);
    var claimedWidth = controlColumnWidths + definedColumnsWidth;
    var widthToFill = gridWidth - claimedWidth;
    var unsizedColumnCount = columns.length - columnsWithWidths.length;
    if (unsizedColumnCount === 0) {
      return DEFAULT_COLUMN_WIDTH;
    }
    return Math.max(widthToFill / unsizedColumnCount, DEFAULT_COLUMN_WIDTH);
  }, [gridWidth, columns, leadingControlColumns, trailingControlColumns]);
  return defaultColumnWidth;
};
var doesColumnHaveAnInitialWidth = exports.doesColumnHaveAnInitialWidth = function doesColumnHaveAnInitialWidth(column) {
  return column.hasOwnProperty('initialWidth') && column.initialWidth != null;
};
var useColumnWidths = exports.useColumnWidths = function useColumnWidths(_ref) {
  var columns = _ref.columns,
    leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    defaultColumnWidth = _ref.defaultColumnWidth,
    onColumnResize = _ref.onColumnResize;
  var computeColumnWidths = (0, _react.useCallback)(function () {
    return columns.filter(doesColumnHaveAnInitialWidth).reduce(function (initialWidths, column) {
      return _objectSpread(_objectSpread({}, initialWidths), {}, (0, _defineProperty2.default)({}, column.id, column.initialWidth));
    }, {});
  }, [columns]);

  // Passes initializer function for performance, so computing only runs once on init
  // @see https://react.dev/reference/react/useState#examples-initializer
  var _useState = (0, _react.useState)(computeColumnWidths),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    columnWidths = _useState2[0],
    setColumnWidths = _useState2[1];
  (0, _services.useUpdateEffect)(function () {
    setColumnWidths(computeColumnWidths());
  }, [computeColumnWidths]);
  var setColumnWidth = (0, _react.useCallback)(function (columnId, width) {
    setColumnWidths(function (prevColumnWidths) {
      return _objectSpread(_objectSpread({}, prevColumnWidths), {}, (0, _defineProperty2.default)({}, columnId, width));
    });
    onColumnResize === null || onColumnResize === void 0 || onColumnResize({
      columnId: columnId,
      width: width
    });
  }, [onColumnResize]);

  // Used by react-window to determine actual column widths
  var getColumnWidth = (0, _react.useCallback)(function (index) {
    // Leading control columns
    if (leadingControlColumns.length && index < leadingControlColumns.length) {
      return leadingControlColumns[index].width;
    }
    // Trailing control columns
    if (trailingControlColumns.length && index >= leadingControlColumns.length + columns.length) {
      return trailingControlColumns[index - leadingControlColumns.length - columns.length].width;
    }
    // Normal data columns
    var columnId = columns.length > 0 ? columns[index - leadingControlColumns.length].id : '';
    return columnWidths[columnId] || defaultColumnWidth || DEFAULT_COLUMN_WIDTH;
  }, [columns, leadingControlColumns, trailingControlColumns, columnWidths, defaultColumnWidth]);
  return {
    columnWidths: columnWidths,
    setColumnWidth: setColumnWidth,
    getColumnWidth: getColumnWidth
  };
};