"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _focus_trap = require("../../../focus_trap");
var _accessibility = require("../../../accessibility");
var _react2 = require("@emotion/react");
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2018 HackerOne Inc and individual contributors
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */
var MonthDropdownOptions = exports.default = /*#__PURE__*/function (_React$Component) {
  function MonthDropdownOptions() {
    var _this;
    (0, _classCallCheck2.default)(this, MonthDropdownOptions);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, MonthDropdownOptions, [].concat(args));
    (0, _defineProperty2.default)(_this, "renderOptions", function () {
      return _this.props.monthNames.map(function (month, i) {
        return (0, _react2.jsx)("div", {
          className: (0, _classnames.default)("react-datepicker__month-option", {
            "react-datepicker__month-option--selected_month": _this.props.month === i,
            "react-datepicker__month-option--preselected": _this.props.accessibleMode && _this.state.preSelection === i
          }),
          key: month,
          ref: month,
          onClick: _this.onChange.bind(_this, i)
        }, _this.props.month === i ? (0, _react2.jsx)("span", {
          className: "react-datepicker__month-option--selected"
        }, "\u2713") : "", month);
      });
    });
    (0, _defineProperty2.default)(_this, "onFocus", function () {
      if (_this.props.accessibleMode) {
        _this.setState({
          readInstructions: true
        });
      }
    });
    (0, _defineProperty2.default)(_this, "onChange", function (month) {
      return _this.props.onChange(month);
    });
    (0, _defineProperty2.default)(_this, "handleClickOutside", function () {
      return _this.props.onCancel();
    });
    (0, _defineProperty2.default)(_this, "onInputKeyDown", function (event) {
      var eventKey = event.key;
      var selectionChange = 0;
      switch (eventKey) {
        case "ArrowUp":
          event.preventDefault();
          event.stopPropagation();
          selectionChange = -1;
          break;
        case "ArrowDown":
          event.preventDefault();
          event.stopPropagation();
          selectionChange = 1;
          break;
        case "Escape":
          event.preventDefault();
          event.stopPropagation();
          _this.props.onCancel();
          break;
        case " ":
        case "Enter":
          event.preventDefault();
          event.stopPropagation();
          _this.props.onChange(_this.state.preSelection);
          break;
      }
      if (selectionChange) {
        _this.setState(function (_ref) {
          var preSelection = _ref.preSelection;
          var nextSelection = preSelection + selectionChange;
          if (nextSelection < 0) nextSelection = 11;
          if (nextSelection === 12) nextSelection = 0;
          return {
            preSelection: nextSelection
          };
        });
      }
    });
    _this.state = {
      preSelection: _this.props.month,
      readInstructions: false
    };
    return _this;
  }
  (0, _inherits2.default)(MonthDropdownOptions, _React$Component);
  return (0, _createClass2.default)(MonthDropdownOptions, [{
    key: "render",
    value: function render() {
      var screenReaderInstructions;
      if (this.state.readInstructions) {
        screenReaderInstructions = (0, _react2.jsx)("p", {
          "aria-live": true
        }, "You are focused on a month selector menu. Use the up and down arrows to select a year, then hit enter to confirm your selection.", this.props.monthNames[this.state.preSelection], " is the currently focused month.");
      }
      return this.props.accessibleMode ? (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
        onClickOutside: this.handleClickOutside
      }, (0, _react2.jsx)("div", {
        className: "react-datepicker__month-dropdown",
        tabIndex: "0",
        onKeyDown: this.onInputKeyDown,
        onFocus: this.onFocus
      }, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, screenReaderInstructions)), this.renderOptions())) : (0, _react2.jsx)("div", {
        className: "react-datepicker__month-dropdown"
      }, this.renderOptions());
    }
  }]);
}(_react.default.Component);
(0, _defineProperty2.default)(MonthDropdownOptions, "propTypes", {
  onCancel: _propTypes.default.func.isRequired,
  onChange: _propTypes.default.func.isRequired,
  month: _propTypes.default.number.isRequired,
  monthNames: _propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired,
  accessibleMode: _propTypes.default.bool
});
module.exports = exports.default;