"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiReactDatePickerStyles = exports.euiDatePickerVariables = exports._timeSelectStyles = exports._monthYearDropdowns = exports._dayCalendarStyles = void 0;
var _css = require("@emotion/css");
var _global_styling = require("../../global_styling");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
var _form = require("../form/form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Needs to use vanilla `css` to pass a className directly to react-datepicker

var euiDatePickerVariables = exports.euiDatePickerVariables = function euiDatePickerVariables(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    gapSize: euiTheme.size.xs,
    get paddingSize() {
      return (0, _global_styling.mathWithUnits)(this.gapSize, function (x) {
        return x * 2;
      });
    },
    headerButtonSize: euiTheme.size.xl,
    get headerOffset() {
      return (0, _global_styling.mathWithUnits)([this.headerButtonSize, this.gapSize], function (x, y) {
        return x + y;
      });
    }
  };
};
var euiReactDatePickerStyles = exports.euiReactDatePickerStyles = function euiReactDatePickerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDatePickerVariabl = euiDatePickerVariables(euiThemeContext),
    gapSize = _euiDatePickerVariabl.gapSize,
    paddingSize = _euiDatePickerVariabl.paddingSize,
    headerOffset = _euiDatePickerVariabl.headerOffset;
  return {
    euiReactDatePicker: /*#__PURE__*/(0, _css.css)("display:flex;justify-content:center;padding:", paddingSize, ";font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";color:", euiTheme.colors.text, ";border-radius:", euiTheme.border.radius.medium, ";&.react-datepicker--non-interactive{pointer-events:none;}.react-datepicker__focusTrap{display:flex;justify-content:center;gap:", paddingSize, ";}", (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, 's'), "{&,.react-datepicker__focusTrap{flex-direction:column;}}.react-datepicker__header__dropdown{position:absolute;", (0, _global_styling.logicalCSS)('top', 0), " ", (0, _global_styling.logicalCSS)('horizontal', headerOffset), " padding:", paddingSize, ";display:flex;justify-content:center;gap:", gapSize, ";}.react-datepicker__navigation{z-index:1;position:absolute;", (0, _global_styling.logicalCSS)('top', paddingSize), "&:hover,&:focus{transform:none;}}.react-datepicker__navigation--previous{", (0, _global_styling.logicalCSS)('left', paddingSize), ";}.react-datepicker__navigation--next{", (0, _global_styling.logicalCSS)('right', paddingSize), ";}.react-datepicker__month-container{flex-grow:1;", (0, _global_styling.logicalCSS)('margin-top', headerOffset), ";}.react-datepicker__time-container{flex-grow:1;", (0, _global_styling.logicalCSS)('margin-top',
    // The time select gets a little extra offset
    (0, _global_styling.mathWithUnits)([headerOffset, gapSize], function (x, y) {
      return x + y;
    })), " ", (0, _global_styling.logicalCSS)('margin-left', paddingSize), (0, _global_styling.euiMaxBreakpoint)(euiThemeContext, 's'), "{", (0, _global_styling.logicalCSS)('margin-top', gapSize), " ", (0, _global_styling.logicalCSS)('margin-left', 0), ";}}", _monthYearDropdowns(euiThemeContext), " ", _dayCalendarStyles(euiThemeContext), " ", _timeSelectStyles(euiThemeContext), ";;label:euiReactDatePicker;")
  };
};
var _monthYearDropdowns = exports._monthYearDropdowns = function _monthYearDropdowns(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var formStyles = (0, _form.euiFormControlStyles)(euiThemeContext);
  return /*#__PURE__*/(0, _css.css)(".react-datepicker__year-read-view,.react-datepicker__month-read-view,.react-datepicker__month-year-read-view{display:flex;justify-content:space-between;align-items:center;", formStyles.compressed, " ", (0, _form.euiFormControlText)(euiThemeContext), " font-weight:", euiTheme.font.weight.medium, ";", (0, _form.euiFormControlDefaultShadow)(euiThemeContext), " &:hover{cursor:pointer;text-decoration:underline;}}.react-datepicker__year-dropdown-container{position:relative;flex-grow:1;}.react-datepicker__month-dropdown-container{position:relative;flex-grow:2;}.react-datepicker__year-dropdown,.react-datepicker__month-dropdown{z-index:1;position:absolute;", (0, _global_styling.euiYScroll)(euiThemeContext, {
    height: 'auto'
  }), " ", (0, _global_styling.logicalCSS)('max-height', '250px'), " ", (0, _global_styling.logicalCSS)('width', '100%'), " padding:", euiTheme.size.xs, ";background-color:", euiTheme.colors.emptyShade, ";border-radius:", euiTheme.border.radius.medium, ";", (0, _mixins.euiShadowSmall)(euiThemeContext), ";}.react-datepicker__year-dropdown{", (0, _global_styling.logicalCSS)('min-width', '100px'), ";}.react-datepicker__month-dropdown{", (0, _global_styling.logicalCSS)('min-width', '140px'), ";}.react-datepicker__year-option,.react-datepicker__month-option,.react-datepicker__month-year-option{", (0, _global_styling.logicalCSS)('margin-vertical', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('height', euiTheme.size.l), " line-height:", euiTheme.size.l, ";font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";border-radius:", euiTheme.border.radius.small, ";cursor:pointer;&:hover{text-decoration:underline;}&--preselected{background-color:", euiTheme.focus.backgroundColor, ";}&--selected_year,&--selected_month{", (0, _mixins.euiButtonFillColor)(euiThemeContext, 'primary'), ";}&--selected{display:none;}}");
};
var _dayCalendarStyles = exports._dayCalendarStyles = function _dayCalendarStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDatePickerVariabl2 = euiDatePickerVariables(euiThemeContext),
    gapSize = _euiDatePickerVariabl2.gapSize;
  var daySize = euiTheme.size.xl;
  var dayMargin = (0, _global_styling.mathWithUnits)(gapSize, function (x) {
    return x / 2;
  });
  var rangeBackgroundColor = (0, _mixins.euiButtonColor)(euiThemeContext, 'primary').backgroundColor;
  var rangeMarginOffset = (0, _global_styling.mathWithUnits)(dayMargin, function (x) {
    return x * 1.5;
  });
  var animationSpeed = euiTheme.animation.fast;
  return /*#__PURE__*/(0, _css.css)(".react-datepicker__day-names,.react-datepicker__week{display:flex;justify-content:space-between;flex-grow:1;color:", euiTheme.colors.subduedText, ";}.react-datepicker__day-name,.react-datepicker__day{display:inline-block;", (0, _global_styling.logicalCSS)('width', daySize), " line-height:", daySize, ";margin:", dayMargin, ";font-weight:", euiTheme.font.weight.medium, ";text-align:center;}.react-datepicker__day{color:", euiTheme.colors.title, ";border-radius:", euiTheme.border.radius.small, ";", _global_styling.euiCanAnimate, "{transition:transform ", animationSpeed, " ease-in-out,background-color ", animationSpeed, " ease-in;}&:hover{", (0, _mixins.euiButtonColor)(euiThemeContext, 'primary'), " text-decoration:underline;cursor:pointer;", _global_styling.euiCanAnimate, "{transform:scale(1.1);}}&--today{color:", euiTheme.colors.primary, ";font-weight:", euiTheme.font.weight.bold, ";}&--outside-month{color:", euiTheme.colors.subduedText, ";}&--highlighted,&--highlighted:hover{", (0, _mixins.euiButtonColor)(euiThemeContext, 'success'), ";}&--in-range,&--in-range:hover{", (0, _mixins.euiButtonColor)(euiThemeContext, 'primary'), ";}&--in-range:not(&--selected):not(:hover):not(&--disabled){box-shadow:-", rangeMarginOffset, " 0 ", rangeBackgroundColor, ",", rangeMarginOffset, " 0 ", rangeBackgroundColor, ";border-radius:0;&:first-child{box-shadow:", rangeMarginOffset, " 0 ", rangeBackgroundColor, ";}&:last-child{box-shadow:-", rangeMarginOffset, " 0 ", rangeBackgroundColor, ";}}&--in-range:not(&--selected){", _global_styling.euiCanAnimate, "{transition:transform ", animationSpeed, " ease-in-out,box-shadow ", animationSpeed, " ease-in-out,border-radius ", animationSpeed, " ease-in-out,background-color ", animationSpeed, " ease-in;}}&--selected,&--selected:hover,&--in-selecting-range,&--in-selecting-range:hover{", (0, _mixins.euiButtonFillColor)(euiThemeContext, 'primary'), ";}&--disabled,&--disabled:hover{", (0, _mixins.euiButtonColor)(euiThemeContext, 'disabled'), " cursor:not-allowed;text-decoration:none;transform:none;}&--disabled.react-datepicker__day--in-range:not(&--selected){&,&:hover{background-color:", (0, _mixins.euiButtonEmptyColor)(euiThemeContext, 'primary').backgroundColor, ";}}&--in-selecting-range:not(&--in-range),&--disabled.react-datepicker__day--selected,&--disabled.react-datepicker__day--selected:hover{", (0, _mixins.euiButtonColor)(euiThemeContext, 'danger'), ";}}");
};
var _timeSelectStyles = exports._timeSelectStyles = function _timeSelectStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDatePickerVariabl3 = euiDatePickerVariables(euiThemeContext),
    gapSize = _euiDatePickerVariabl3.gapSize;
  return /*#__PURE__*/(0, _css.css)(".react-datepicker__time-container{display:flex;", (0, _global_styling.logicalCSS)('width', 'auto'), " background-color:", euiTheme.colors.body, ";border-radius:", euiTheme.border.radius.medium, ";&--focus{.react-datepicker__time-list-item--preselected{text-decoration:underline;}}}.react-datepicker__time,.react-datepicker__time-box{display:flex;flex-direction:column;flex-grow:1;}.react-datepicker__time-list{", (0, _global_styling.euiYScroll)(euiThemeContext, {
    height: '100px'
  }), " display:flex;flex-direction:column;flex-grow:1;align-items:center;gap:", gapSize, ";", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.m), " &:focus-visible{outline-style:auto;}}.react-datepicker__time-list-item{", (0, _global_styling.logicalCSS)('margin-horizontal', 'auto'), ";", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.s), ";", (0, _global_styling.logicalCSS)('height', euiTheme.size.l), " line-height:", euiTheme.size.l, ";font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";font-weight:", euiTheme.font.weight.medium, ";white-space:nowrap;text-align:center;border-radius:", euiTheme.border.radius.small, ";&:not(:disabled):hover{text-decoration:underline;cursor:pointer;}&--disabled{cursor:not-allowed;color:", euiTheme.colors.disabledText, ";}&--injected{", (0, _mixins.euiButtonEmptyColor)(euiThemeContext, 'success'), ";}&--selected{", (0, _mixins.euiButtonFillColor)(euiThemeContext, 'primary'), ";}&--preselected{background-color:", euiTheme.focus.backgroundColor, ";}", _global_styling.euiCanAnimate, "{transition:background-color ", euiTheme.animation.fast, " ease-in;}}&.react-datepicker--time-only{padding:0;.react-datepicker__time-container{background-color:transparent;margin:0;}.react-datepicker__time-list{", (0, _global_styling.logicalCSS)('height', '204px'), ";}.react-datepicker__time-list-item{", (0, _global_styling.logicalCSS)('min-width', '112px'), " font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";text-align:start;}}");
};