"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAbsoluteTab = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _moment = _interopRequireDefault(require("moment"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _services = require("../../../../services");
var _i18n = require("../../../i18n");
var _form = require("../../../form");
var _flex = require("../../../flex");
var _button = require("../../../button");
var _code = require("../../../code");
var _date_picker = require("../../date_picker");
var _absolute_tab = require("./absolute_tab.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Allow users to paste in and have the datepicker parse multiple common date formats,
// in addition to the configured displayed `dateFormat` prop
var ALLOWED_USER_DATE_FORMATS = [_moment.default.ISO_8601, _moment.default.RFC_2822, 'X' // Unix timestamp in seconds
];
var EuiAbsoluteTab = exports.EuiAbsoluteTab = function EuiAbsoluteTab(_ref) {
  var value = _ref.value,
    onChange = _ref.onChange,
    dateFormat = _ref.dateFormat,
    timeFormat = _ref.timeFormat,
    locale = _ref.locale,
    roundUp = _ref.roundUp,
    utcOffset = _ref.utcOffset,
    minDate = _ref.minDate,
    maxDate = _ref.maxDate,
    labelPrefix = _ref.labelPrefix;
  var styles = (0, _services.useEuiMemoizedStyles)(_absolute_tab.euiAbsoluteTabDateFormStyles);
  var _useState = (0, _react.useState)(function () {
      var parsedValue = _datemath.default.parse(value, {
        roundUp: roundUp
      });
      return parsedValue && parsedValue.isValid() ? parsedValue : (0, _moment.default)();
    }),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    valueAsMoment = _useState2[0],
    setValueAsMoment = _useState2[1];
  var handleChange = (0, _react.useCallback)(function (date) {
    if (date === null) return;
    var valueAsMoment = (0, _moment.default)(date);
    setValueAsMoment(valueAsMoment);
    setTextInputValue(valueAsMoment.format(dateFormat));
    setHasUnparsedText(false);
    setIsTextInvalid(false);
  }, [dateFormat]);
  var submitButtonLabel = (0, _i18n.useEuiI18n)('euiAbsoluteTab.dateFormatButtonLabel', 'Parse date');
  var dateFormatError = (0, _i18n.useEuiI18n)('euiAbsoluteTab.dateFormatError', 'Allowed formats: {dateFormat}, ISO 8601, RFC 2822, or Unix timestamp.', {
    dateFormat: (0, _react2.jsx)(_code.EuiCode, null, dateFormat)
  });
  var _useState3 = (0, _react.useState)(function () {
      return valueAsMoment.locale(locale || 'en').format(dateFormat);
    }),
    _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
    textInputValue = _useState4[0],
    setTextInputValue = _useState4[1];
  var _useState5 = (0, _react.useState)(false),
    _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
    hasUnparsedText = _useState6[0],
    setHasUnparsedText = _useState6[1];
  var _useState7 = (0, _react.useState)(false),
    _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
    isReadyToParse = _useState8[0],
    setIsReadyToParse = _useState8[1];
  var _useState9 = (0, _react.useState)(false),
    _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
    isTextInvalid = _useState10[0],
    setIsTextInvalid = _useState10[1];
  var handleTextChange = (0, _react.useCallback)(function (event) {
    if (isReadyToParse) return; // Text paste event, don't continue

    setTextInputValue(event.target.value);
    setHasUnparsedText(true);
    setIsTextInvalid(false);
  }, [isReadyToParse]);
  (0, _react.useEffect)(function () {
    if (isReadyToParse) {
      if (!textInputValue) {
        setIsTextInvalid(true);
        setValueAsMoment(null);
        return;
      }

      // Attempt to parse with passed `dateFormat` and `locale`
      var _valueAsMoment = (0, _moment.default)(textInputValue, dateFormat, typeof locale === 'string' ? locale : 'en',
      // Narrow the union type to string
      true);
      var dateIsValid = _valueAsMoment.isValid();

      // If not valid, try a few other standardized formats
      if (!dateIsValid) {
        _valueAsMoment = (0, _moment.default)(textInputValue, ALLOWED_USER_DATE_FORMATS, true);
        dateIsValid = _valueAsMoment.isValid();
      }
      if (dateIsValid) {
        setTextInputValue(_valueAsMoment.format(dateFormat));
        setValueAsMoment(_valueAsMoment);
        setHasUnparsedText(false);
        setIsTextInvalid(false);
      } else {
        setIsTextInvalid(true);
        setValueAsMoment(null);
      }
      setIsReadyToParse(false);
    }
  }, [isReadyToParse, textInputValue, dateFormat, locale]);
  (0, _services.useUpdateEffect)(function () {
    if (valueAsMoment) {
      onChange(valueAsMoment.toISOString());
    }
  }, [valueAsMoment]);
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_date_picker.EuiDatePicker, {
    inline: true,
    showTimeSelect: true,
    shadow: false,
    selected: valueAsMoment,
    onChange: handleChange,
    dateFormat: dateFormat,
    timeFormat: timeFormat,
    locale: locale,
    utcOffset: utcOffset,
    minDate: minDate,
    maxDate: maxDate
  }), (0, _react2.jsx)(_flex.EuiFlexGroup, {
    component: "form",
    onSubmit: function onSubmit(e) {
      e.preventDefault(); // Prevents a page refresh/reload
      setIsReadyToParse(true);
    },
    css: styles.euiAbsoluteTabDateForm,
    gutterSize: "s",
    responsive: false
  }, (0, _react2.jsx)(_form.EuiFormRow, {
    css: styles.euiAbsoluteTabDateForm__row,
    isInvalid: isTextInvalid,
    error: isTextInvalid ? dateFormatError : undefined,
    helpText: hasUnparsedText && !isTextInvalid ? dateFormatError : undefined
  }, (0, _react2.jsx)(_form.EuiFieldText, {
    compressed: true,
    isInvalid: isTextInvalid,
    value: textInputValue,
    onChange: handleTextChange,
    onPaste: function onPaste(event) {
      setTextInputValue(event.clipboardData.getData('text'));
      setIsReadyToParse(true);
    },
    "data-test-subj": "superDatePickerAbsoluteDateInput",
    prepend: (0, _react2.jsx)(_form.EuiFormLabel, null, labelPrefix)
  })), hasUnparsedText && (0, _react2.jsx)(_button.EuiButtonIcon, {
    type: "submit",
    css: styles.euiAbsoluteTabDateForm__submit,
    size: "s",
    display: "base",
    iconType: "check",
    "aria-label": submitButtonLabel,
    title: submitButtonLabel,
    "data-test-subj": "parseAbsoluteDateFormat"
  })));
};
EuiAbsoluteTab.propTypes = {
  dateFormat: _propTypes.default.string.isRequired,
  timeFormat: _propTypes.default.string.isRequired,
  locale: _propTypes.default.any,
  value: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func.isRequired,
  roundUp: _propTypes.default.bool.isRequired,
  labelPrefix: _propTypes.default.string.isRequired,
  utcOffset: _propTypes.default.number,
  minDate: _propTypes.default.any,
  maxDate: _propTypes.default.any
};